import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsVpcEndpointServiceConfig extends TerraformMetaArguments {
    readonly service?: string;
    readonly serviceName?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** filter block */
    readonly filter?: DataAwsVpcEndpointServiceFilter[];
}
export interface DataAwsVpcEndpointServiceFilter {
    readonly name: string;
    readonly values: string[];
}
export declare class DataAwsVpcEndpointService extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsVpcEndpointServiceConfig);
    get acceptanceRequired(): boolean;
    get arn(): string;
    get availabilityZones(): string[];
    get baseEndpointDnsNames(): string[];
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get managesVpcEndpoints(): boolean;
    get owner(): string;
    get privateDnsName(): string;
    private _service?;
    get service(): string | undefined;
    set service(value: string | undefined);
    get serviceId(): string;
    private _serviceName?;
    get serviceName(): string | undefined;
    set serviceName(value: string | undefined);
    get serviceType(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get vpcEndpointPolicySupported(): boolean;
    private _filter?;
    get filter(): DataAwsVpcEndpointServiceFilter[] | undefined;
    set filter(value: DataAwsVpcEndpointServiceFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
