import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsVpcEndpointConfig extends TerraformMetaArguments {
    readonly serviceName?: string;
    readonly state?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly vpcId?: string;
    /** filter block */
    readonly filter?: DataAwsVpcEndpointFilter[];
}
export declare class DataAwsVpcEndpointDnsEntry extends ComplexComputedList {
    get dnsName(): string;
    get hostedZoneId(): string;
}
export interface DataAwsVpcEndpointFilter {
    readonly name: string;
    readonly values: string[];
}
export declare class DataAwsVpcEndpoint extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsVpcEndpointConfig);
    get arn(): string;
    get cidrBlocks(): string[];
    dnsEntry(index: string): DataAwsVpcEndpointDnsEntry;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get networkInterfaceIds(): string[];
    get ownerId(): string;
    get policy(): string;
    get prefixListId(): string;
    get privateDnsEnabled(): boolean;
    get requesterManaged(): boolean;
    get routeTableIds(): string[];
    get securityGroupIds(): string[];
    private _serviceName?;
    get serviceName(): string | undefined;
    set serviceName(value: string | undefined);
    private _state?;
    get state(): string | undefined;
    set state(value: string | undefined);
    get subnetIds(): string[];
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get vpcEndpointType(): string;
    private _vpcId?;
    get vpcId(): string | undefined;
    set vpcId(value: string | undefined);
    private _filter?;
    get filter(): DataAwsVpcEndpointFilter[] | undefined;
    set filter(value: DataAwsVpcEndpointFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
