import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsVpcPeeringConnectionConfig extends TerraformMetaArguments {
    readonly cidrBlock?: string;
    readonly ownerId?: string;
    readonly peerCidrBlock?: string;
    readonly peerOwnerId?: string;
    readonly peerRegion?: string;
    readonly peerVpcId?: string;
    readonly region?: string;
    readonly status?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly vpcId?: string;
    /** filter block */
    readonly filter?: DataAwsVpcPeeringConnectionFilter[];
}
export interface DataAwsVpcPeeringConnectionFilter {
    readonly name: string;
    readonly values: string[];
}
export declare class DataAwsVpcPeeringConnection extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsVpcPeeringConnectionConfig);
    accepter(key: string): boolean;
    private _cidrBlock?;
    get cidrBlock(): string | undefined;
    set cidrBlock(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _ownerId?;
    get ownerId(): string | undefined;
    set ownerId(value: string | undefined);
    private _peerCidrBlock?;
    get peerCidrBlock(): string | undefined;
    set peerCidrBlock(value: string | undefined);
    private _peerOwnerId?;
    get peerOwnerId(): string | undefined;
    set peerOwnerId(value: string | undefined);
    private _peerRegion?;
    get peerRegion(): string | undefined;
    set peerRegion(value: string | undefined);
    private _peerVpcId?;
    get peerVpcId(): string | undefined;
    set peerVpcId(value: string | undefined);
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    requester(key: string): boolean;
    private _status?;
    get status(): string | undefined;
    set status(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _vpcId?;
    get vpcId(): string | undefined;
    set vpcId(value: string | undefined);
    private _filter?;
    get filter(): DataAwsVpcPeeringConnectionFilter[] | undefined;
    set filter(value: DataAwsVpcPeeringConnectionFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
