import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsVpcConfig extends TerraformMetaArguments {
    readonly cidrBlock?: string;
    readonly default?: boolean;
    readonly dhcpOptionsId?: string;
    readonly state?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** filter block */
    readonly filter?: DataAwsVpcFilter[];
}
export declare class DataAwsVpcCidrBlockAssociations extends ComplexComputedList {
    get associationId(): string;
    get cidrBlock(): string;
    get state(): string;
}
export interface DataAwsVpcFilter {
    readonly name: string;
    readonly values: string[];
}
export declare class DataAwsVpc extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsVpcConfig);
    get arn(): string;
    private _cidrBlock?;
    get cidrBlock(): string | undefined;
    set cidrBlock(value: string | undefined);
    cidrBlockAssociations(index: string): DataAwsVpcCidrBlockAssociations;
    private _default?;
    get default(): boolean | undefined;
    set default(value: boolean | undefined);
    private _dhcpOptionsId?;
    get dhcpOptionsId(): string | undefined;
    set dhcpOptionsId(value: string | undefined);
    get enableDnsHostnames(): boolean;
    get enableDnsSupport(): boolean;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get instanceTenancy(): string;
    get ipv6AssociationId(): string;
    get ipv6CidrBlock(): string;
    get mainRouteTableId(): string;
    get ownerId(): string;
    private _state?;
    get state(): string | undefined;
    set state(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _filter?;
    get filter(): DataAwsVpcFilter[] | undefined;
    set filter(value: DataAwsVpcFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
