import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsWorkspacesBundleConfig extends TerraformMetaArguments {
    readonly bundleId?: string;
    readonly name?: string;
    readonly owner?: string;
}
export declare class DataAwsWorkspacesBundleComputeType extends ComplexComputedList {
    get name(): string;
}
export declare class DataAwsWorkspacesBundleRootStorage extends ComplexComputedList {
    get capacity(): string;
}
export declare class DataAwsWorkspacesBundleUserStorage extends ComplexComputedList {
    get capacity(): string;
}
export declare class DataAwsWorkspacesBundle extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsWorkspacesBundleConfig);
    private _bundleId?;
    get bundleId(): string | undefined;
    set bundleId(value: string | undefined);
    computeType(index: string): DataAwsWorkspacesBundleComputeType;
    get description(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _owner?;
    get owner(): string | undefined;
    set owner(value: string | undefined);
    rootStorage(index: string): DataAwsWorkspacesBundleRootStorage;
    userStorage(index: string): DataAwsWorkspacesBundleUserStorage;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
