import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DatasyncAgentConfig extends TerraformMetaArguments {
    readonly activationKey?: string;
    readonly ipAddress?: string;
    readonly name?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** timeouts block */
    readonly timeouts?: DatasyncAgentTimeouts;
}
export interface DatasyncAgentTimeouts {
    readonly create?: string;
}
export declare class DatasyncAgent extends TerraformResource {
    constructor(scope: Construct, id: string, config?: DatasyncAgentConfig);
    private _activationKey?;
    get activationKey(): string | undefined;
    set activationKey(value: string | undefined);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _ipAddress?;
    get ipAddress(): string | undefined;
    set ipAddress(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _timeouts?;
    get timeouts(): DatasyncAgentTimeouts | undefined;
    set timeouts(value: DatasyncAgentTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
