import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DatasyncLocationEfsConfig extends TerraformMetaArguments {
    readonly efsFileSystemArn: string;
    readonly subdirectory?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** ec2_config block */
    readonly ec2Config: DatasyncLocationEfsEc2Config[];
}
export interface DatasyncLocationEfsEc2Config {
    readonly securityGroupArns: string[];
    readonly subnetArn: string;
}
export declare class DatasyncLocationEfs extends TerraformResource {
    constructor(scope: Construct, id: string, config: DatasyncLocationEfsConfig);
    get arn(): string;
    private _efsFileSystemArn;
    get efsFileSystemArn(): string;
    set efsFileSystemArn(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _subdirectory?;
    get subdirectory(): string | undefined;
    set subdirectory(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get uri(): string;
    private _ec2Config;
    get ec2Config(): DatasyncLocationEfsEc2Config[];
    set ec2Config(value: DatasyncLocationEfsEc2Config[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
