import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DatasyncLocationNfsConfig extends TerraformMetaArguments {
    readonly serverHostname: string;
    readonly subdirectory: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** on_prem_config block */
    readonly onPremConfig: DatasyncLocationNfsOnPremConfig[];
}
export interface DatasyncLocationNfsOnPremConfig {
    readonly agentArns: string[];
}
export declare class DatasyncLocationNfs extends TerraformResource {
    constructor(scope: Construct, id: string, config: DatasyncLocationNfsConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _serverHostname;
    get serverHostname(): string;
    set serverHostname(value: string);
    private _subdirectory;
    get subdirectory(): string;
    set subdirectory(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get uri(): string;
    private _onPremConfig;
    get onPremConfig(): DatasyncLocationNfsOnPremConfig[];
    set onPremConfig(value: DatasyncLocationNfsOnPremConfig[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
