import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DatasyncLocationS3Config extends TerraformMetaArguments {
    readonly s3BucketArn: string;
    readonly subdirectory: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** s3_config block */
    readonly s3Config: DatasyncLocationS3S3Config[];
}
export interface DatasyncLocationS3S3Config {
    readonly bucketAccessRoleArn: string;
}
export declare class DatasyncLocationS3 extends TerraformResource {
    constructor(scope: Construct, id: string, config: DatasyncLocationS3Config);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _s3BucketArn;
    get s3BucketArn(): string;
    set s3BucketArn(value: string);
    private _subdirectory;
    get subdirectory(): string;
    set subdirectory(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get uri(): string;
    private _s3Config;
    get s3Config(): DatasyncLocationS3S3Config[];
    set s3Config(value: DatasyncLocationS3S3Config[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
