import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DatasyncLocationSmbConfig extends TerraformMetaArguments {
    readonly agentArns: string[];
    readonly domain?: string;
    readonly password: string;
    readonly serverHostname: string;
    readonly subdirectory: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly user: string;
    /** mount_options block */
    readonly mountOptions?: DatasyncLocationSmbMountOptions[];
}
export interface DatasyncLocationSmbMountOptions {
    readonly version?: string;
}
export declare class DatasyncLocationSmb extends TerraformResource {
    constructor(scope: Construct, id: string, config: DatasyncLocationSmbConfig);
    private _agentArns;
    get agentArns(): string[];
    set agentArns(value: string[]);
    get arn(): string;
    private _domain?;
    get domain(): string | undefined;
    set domain(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _password;
    get password(): string;
    set password(value: string);
    private _serverHostname;
    get serverHostname(): string;
    set serverHostname(value: string);
    private _subdirectory;
    get subdirectory(): string;
    set subdirectory(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get uri(): string;
    private _user;
    get user(): string;
    set user(value: string);
    private _mountOptions?;
    get mountOptions(): DatasyncLocationSmbMountOptions[] | undefined;
    set mountOptions(value: DatasyncLocationSmbMountOptions[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
