import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DatasyncTaskConfig extends TerraformMetaArguments {
    readonly cloudwatchLogGroupArn?: string;
    readonly destinationLocationArn: string;
    readonly name?: string;
    readonly sourceLocationArn: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** options block */
    readonly options?: DatasyncTaskOptions[];
    /** timeouts block */
    readonly timeouts?: DatasyncTaskTimeouts;
}
export interface DatasyncTaskOptions {
    readonly atime?: string;
    readonly bytesPerSecond?: number;
    readonly gid?: string;
    readonly mtime?: string;
    readonly posixPermissions?: string;
    readonly preserveDeletedFiles?: string;
    readonly preserveDevices?: string;
    readonly uid?: string;
    readonly verifyMode?: string;
}
export interface DatasyncTaskTimeouts {
    readonly create?: string;
}
export declare class DatasyncTask extends TerraformResource {
    constructor(scope: Construct, id: string, config: DatasyncTaskConfig);
    get arn(): string;
    private _cloudwatchLogGroupArn?;
    get cloudwatchLogGroupArn(): string | undefined;
    set cloudwatchLogGroupArn(value: string | undefined);
    private _destinationLocationArn;
    get destinationLocationArn(): string;
    set destinationLocationArn(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _sourceLocationArn;
    get sourceLocationArn(): string;
    set sourceLocationArn(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _options?;
    get options(): DatasyncTaskOptions[] | undefined;
    set options(value: DatasyncTaskOptions[] | undefined);
    private _timeouts?;
    get timeouts(): DatasyncTaskTimeouts | undefined;
    set timeouts(value: DatasyncTaskTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
