import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DaxClusterConfig extends TerraformMetaArguments {
    readonly availabilityZones?: string[];
    readonly clusterName: string;
    readonly description?: string;
    readonly iamRoleArn: string;
    readonly maintenanceWindow?: string;
    readonly nodeType: string;
    readonly notificationTopicArn?: string;
    readonly parameterGroupName?: string;
    readonly replicationFactor: number;
    readonly securityGroupIds?: string[];
    readonly subnetGroupName?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** server_side_encryption block */
    readonly serverSideEncryption?: DaxClusterServerSideEncryption[];
    /** timeouts block */
    readonly timeouts?: DaxClusterTimeouts;
}
export declare class DaxClusterNodes extends ComplexComputedList {
    get address(): string;
    get availabilityZone(): string;
    get id(): string;
    get port(): number;
}
export interface DaxClusterServerSideEncryption {
    readonly enabled?: boolean;
}
export interface DaxClusterTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class DaxCluster extends TerraformResource {
    constructor(scope: Construct, id: string, config: DaxClusterConfig);
    get arn(): string;
    private _availabilityZones?;
    get availabilityZones(): string[] | undefined;
    set availabilityZones(value: string[] | undefined);
    get clusterAddress(): string;
    private _clusterName;
    get clusterName(): string;
    set clusterName(value: string);
    get configurationEndpoint(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _iamRoleArn;
    get iamRoleArn(): string;
    set iamRoleArn(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _maintenanceWindow?;
    get maintenanceWindow(): string | undefined;
    set maintenanceWindow(value: string | undefined);
    private _nodeType;
    get nodeType(): string;
    set nodeType(value: string);
    nodes(index: string): DaxClusterNodes;
    private _notificationTopicArn?;
    get notificationTopicArn(): string | undefined;
    set notificationTopicArn(value: string | undefined);
    private _parameterGroupName?;
    get parameterGroupName(): string | undefined;
    set parameterGroupName(value: string | undefined);
    get port(): number;
    private _replicationFactor;
    get replicationFactor(): number;
    set replicationFactor(value: number);
    private _securityGroupIds?;
    get securityGroupIds(): string[] | undefined;
    set securityGroupIds(value: string[] | undefined);
    private _subnetGroupName?;
    get subnetGroupName(): string | undefined;
    set subnetGroupName(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _serverSideEncryption?;
    get serverSideEncryption(): DaxClusterServerSideEncryption[] | undefined;
    set serverSideEncryption(value: DaxClusterServerSideEncryption[] | undefined);
    private _timeouts?;
    get timeouts(): DaxClusterTimeouts | undefined;
    set timeouts(value: DaxClusterTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
