import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DaxParameterGroupConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly name: string;
    /** parameters block */
    readonly parameters?: DaxParameterGroupParameters[];
}
export interface DaxParameterGroupParameters {
    readonly name: string;
    readonly value: string;
}
export declare class DaxParameterGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config: DaxParameterGroupConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _parameters?;
    get parameters(): DaxParameterGroupParameters[] | undefined;
    set parameters(value: DaxParameterGroupParameters[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
