import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DbClusterSnapshotConfig extends TerraformMetaArguments {
    readonly dbClusterIdentifier: string;
    readonly dbClusterSnapshotIdentifier: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** timeouts block */
    readonly timeouts?: DbClusterSnapshotTimeouts;
}
export interface DbClusterSnapshotTimeouts {
    readonly create?: string;
}
export declare class DbClusterSnapshot extends TerraformResource {
    constructor(scope: Construct, id: string, config: DbClusterSnapshotConfig);
    get allocatedStorage(): number;
    get availabilityZones(): string[];
    private _dbClusterIdentifier;
    get dbClusterIdentifier(): string;
    set dbClusterIdentifier(value: string);
    get dbClusterSnapshotArn(): string;
    private _dbClusterSnapshotIdentifier;
    get dbClusterSnapshotIdentifier(): string;
    set dbClusterSnapshotIdentifier(value: string);
    get engine(): string;
    get engineVersion(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get kmsKeyId(): string;
    get licenseModel(): string;
    get port(): number;
    get snapshotType(): string;
    get sourceDbClusterSnapshotArn(): string;
    get status(): string;
    get storageEncrypted(): boolean;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get vpcId(): string;
    private _timeouts?;
    get timeouts(): DbClusterSnapshotTimeouts | undefined;
    set timeouts(value: DbClusterSnapshotTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
