import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DbEventSubscriptionConfig extends TerraformMetaArguments {
    readonly enabled?: boolean;
    readonly eventCategories?: string[];
    readonly name?: string;
    readonly namePrefix?: string;
    readonly snsTopic: string;
    readonly sourceIds?: string[];
    readonly sourceType?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** timeouts block */
    readonly timeouts?: DbEventSubscriptionTimeouts;
}
export interface DbEventSubscriptionTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class DbEventSubscription extends TerraformResource {
    constructor(scope: Construct, id: string, config: DbEventSubscriptionConfig);
    get arn(): string;
    get customerAwsId(): string;
    private _enabled?;
    get enabled(): boolean | undefined;
    set enabled(value: boolean | undefined);
    private _eventCategories?;
    get eventCategories(): string[] | undefined;
    set eventCategories(value: string[] | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _snsTopic;
    get snsTopic(): string;
    set snsTopic(value: string);
    private _sourceIds?;
    get sourceIds(): string[] | undefined;
    set sourceIds(value: string[] | undefined);
    private _sourceType?;
    get sourceType(): string | undefined;
    set sourceType(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _timeouts?;
    get timeouts(): DbEventSubscriptionTimeouts | undefined;
    set timeouts(value: DbEventSubscriptionTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
