import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DbInstanceConfig extends TerraformMetaArguments {
    readonly allocatedStorage?: number;
    readonly allowMajorVersionUpgrade?: boolean;
    readonly applyImmediately?: boolean;
    readonly autoMinorVersionUpgrade?: boolean;
    readonly availabilityZone?: string;
    readonly backupRetentionPeriod?: number;
    readonly backupWindow?: string;
    readonly caCertIdentifier?: string;
    readonly characterSetName?: string;
    readonly copyTagsToSnapshot?: boolean;
    readonly dbSubnetGroupName?: string;
    readonly deleteAutomatedBackups?: boolean;
    readonly deletionProtection?: boolean;
    readonly domain?: string;
    readonly domainIamRoleName?: string;
    readonly enabledCloudwatchLogsExports?: string[];
    readonly engine?: string;
    readonly engineVersion?: string;
    readonly finalSnapshotIdentifier?: string;
    readonly iamDatabaseAuthenticationEnabled?: boolean;
    readonly identifier?: string;
    readonly identifierPrefix?: string;
    readonly instanceClass: string;
    readonly iops?: number;
    readonly kmsKeyId?: string;
    readonly licenseModel?: string;
    readonly maintenanceWindow?: string;
    readonly maxAllocatedStorage?: number;
    readonly monitoringInterval?: number;
    readonly monitoringRoleArn?: string;
    readonly multiAz?: boolean;
    readonly name?: string;
    readonly optionGroupName?: string;
    readonly parameterGroupName?: string;
    readonly password?: string;
    readonly performanceInsightsEnabled?: boolean;
    readonly performanceInsightsKmsKeyId?: string;
    readonly performanceInsightsRetentionPeriod?: number;
    readonly port?: number;
    readonly publiclyAccessible?: boolean;
    readonly replicateSourceDb?: string;
    readonly securityGroupNames?: string[];
    readonly skipFinalSnapshot?: boolean;
    readonly snapshotIdentifier?: string;
    readonly storageEncrypted?: boolean;
    readonly storageType?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly timezone?: string;
    readonly username?: string;
    readonly vpcSecurityGroupIds?: string[];
    /** s3_import block */
    readonly s3Import?: DbInstanceS3Import[];
    /** timeouts block */
    readonly timeouts?: DbInstanceTimeouts;
}
export interface DbInstanceS3Import {
    readonly bucketName: string;
    readonly bucketPrefix?: string;
    readonly ingestionRole: string;
    readonly sourceEngine: string;
    readonly sourceEngineVersion: string;
}
export interface DbInstanceTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class DbInstance extends TerraformResource {
    constructor(scope: Construct, id: string, config: DbInstanceConfig);
    get address(): string;
    private _allocatedStorage?;
    get allocatedStorage(): number | undefined;
    set allocatedStorage(value: number | undefined);
    private _allowMajorVersionUpgrade?;
    get allowMajorVersionUpgrade(): boolean | undefined;
    set allowMajorVersionUpgrade(value: boolean | undefined);
    private _applyImmediately?;
    get applyImmediately(): boolean | undefined;
    set applyImmediately(value: boolean | undefined);
    get arn(): string;
    private _autoMinorVersionUpgrade?;
    get autoMinorVersionUpgrade(): boolean | undefined;
    set autoMinorVersionUpgrade(value: boolean | undefined);
    private _availabilityZone?;
    get availabilityZone(): string | undefined;
    set availabilityZone(value: string | undefined);
    private _backupRetentionPeriod?;
    get backupRetentionPeriod(): number | undefined;
    set backupRetentionPeriod(value: number | undefined);
    private _backupWindow?;
    get backupWindow(): string | undefined;
    set backupWindow(value: string | undefined);
    private _caCertIdentifier?;
    get caCertIdentifier(): string | undefined;
    set caCertIdentifier(value: string | undefined);
    private _characterSetName?;
    get characterSetName(): string | undefined;
    set characterSetName(value: string | undefined);
    private _copyTagsToSnapshot?;
    get copyTagsToSnapshot(): boolean | undefined;
    set copyTagsToSnapshot(value: boolean | undefined);
    private _dbSubnetGroupName?;
    get dbSubnetGroupName(): string | undefined;
    set dbSubnetGroupName(value: string | undefined);
    private _deleteAutomatedBackups?;
    get deleteAutomatedBackups(): boolean | undefined;
    set deleteAutomatedBackups(value: boolean | undefined);
    private _deletionProtection?;
    get deletionProtection(): boolean | undefined;
    set deletionProtection(value: boolean | undefined);
    private _domain?;
    get domain(): string | undefined;
    set domain(value: string | undefined);
    private _domainIamRoleName?;
    get domainIamRoleName(): string | undefined;
    set domainIamRoleName(value: string | undefined);
    private _enabledCloudwatchLogsExports?;
    get enabledCloudwatchLogsExports(): string[] | undefined;
    set enabledCloudwatchLogsExports(value: string[] | undefined);
    get endpoint(): string;
    private _engine?;
    get engine(): string | undefined;
    set engine(value: string | undefined);
    private _engineVersion?;
    get engineVersion(): string | undefined;
    set engineVersion(value: string | undefined);
    private _finalSnapshotIdentifier?;
    get finalSnapshotIdentifier(): string | undefined;
    set finalSnapshotIdentifier(value: string | undefined);
    get hostedZoneId(): string;
    private _iamDatabaseAuthenticationEnabled?;
    get iamDatabaseAuthenticationEnabled(): boolean | undefined;
    set iamDatabaseAuthenticationEnabled(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _identifier?;
    get identifier(): string | undefined;
    set identifier(value: string | undefined);
    private _identifierPrefix?;
    get identifierPrefix(): string | undefined;
    set identifierPrefix(value: string | undefined);
    private _instanceClass;
    get instanceClass(): string;
    set instanceClass(value: string);
    private _iops?;
    get iops(): number | undefined;
    set iops(value: number | undefined);
    private _kmsKeyId?;
    get kmsKeyId(): string | undefined;
    set kmsKeyId(value: string | undefined);
    private _licenseModel?;
    get licenseModel(): string | undefined;
    set licenseModel(value: string | undefined);
    private _maintenanceWindow?;
    get maintenanceWindow(): string | undefined;
    set maintenanceWindow(value: string | undefined);
    private _maxAllocatedStorage?;
    get maxAllocatedStorage(): number | undefined;
    set maxAllocatedStorage(value: number | undefined);
    private _monitoringInterval?;
    get monitoringInterval(): number | undefined;
    set monitoringInterval(value: number | undefined);
    private _monitoringRoleArn?;
    get monitoringRoleArn(): string | undefined;
    set monitoringRoleArn(value: string | undefined);
    private _multiAz?;
    get multiAz(): boolean | undefined;
    set multiAz(value: boolean | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _optionGroupName?;
    get optionGroupName(): string | undefined;
    set optionGroupName(value: string | undefined);
    private _parameterGroupName?;
    get parameterGroupName(): string | undefined;
    set parameterGroupName(value: string | undefined);
    private _password?;
    get password(): string | undefined;
    set password(value: string | undefined);
    private _performanceInsightsEnabled?;
    get performanceInsightsEnabled(): boolean | undefined;
    set performanceInsightsEnabled(value: boolean | undefined);
    private _performanceInsightsKmsKeyId?;
    get performanceInsightsKmsKeyId(): string | undefined;
    set performanceInsightsKmsKeyId(value: string | undefined);
    private _performanceInsightsRetentionPeriod?;
    get performanceInsightsRetentionPeriod(): number | undefined;
    set performanceInsightsRetentionPeriod(value: number | undefined);
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    private _publiclyAccessible?;
    get publiclyAccessible(): boolean | undefined;
    set publiclyAccessible(value: boolean | undefined);
    get replicas(): string[];
    private _replicateSourceDb?;
    get replicateSourceDb(): string | undefined;
    set replicateSourceDb(value: string | undefined);
    get resourceId(): string;
    private _securityGroupNames?;
    get securityGroupNames(): string[] | undefined;
    set securityGroupNames(value: string[] | undefined);
    private _skipFinalSnapshot?;
    get skipFinalSnapshot(): boolean | undefined;
    set skipFinalSnapshot(value: boolean | undefined);
    private _snapshotIdentifier?;
    get snapshotIdentifier(): string | undefined;
    set snapshotIdentifier(value: string | undefined);
    get status(): string;
    private _storageEncrypted?;
    get storageEncrypted(): boolean | undefined;
    set storageEncrypted(value: boolean | undefined);
    private _storageType?;
    get storageType(): string | undefined;
    set storageType(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _timezone?;
    get timezone(): string | undefined;
    set timezone(value: string | undefined);
    private _username?;
    get username(): string | undefined;
    set username(value: string | undefined);
    private _vpcSecurityGroupIds?;
    get vpcSecurityGroupIds(): string[] | undefined;
    set vpcSecurityGroupIds(value: string[] | undefined);
    private _s3Import?;
    get s3Import(): DbInstanceS3Import[] | undefined;
    set s3Import(value: DbInstanceS3Import[] | undefined);
    private _timeouts?;
    get timeouts(): DbInstanceTimeouts | undefined;
    set timeouts(value: DbInstanceTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
