"use strict";
// https://www.terraform.io/docs/providers/aws/r/db_instance.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.DbInstance = void 0;
const cdktf_1 = require("cdktf");
// Resource
class DbInstance extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_db_instance',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._allocatedStorage = config.allocatedStorage;
        this._allowMajorVersionUpgrade = config.allowMajorVersionUpgrade;
        this._applyImmediately = config.applyImmediately;
        this._autoMinorVersionUpgrade = config.autoMinorVersionUpgrade;
        this._availabilityZone = config.availabilityZone;
        this._backupRetentionPeriod = config.backupRetentionPeriod;
        this._backupWindow = config.backupWindow;
        this._caCertIdentifier = config.caCertIdentifier;
        this._characterSetName = config.characterSetName;
        this._copyTagsToSnapshot = config.copyTagsToSnapshot;
        this._dbSubnetGroupName = config.dbSubnetGroupName;
        this._deleteAutomatedBackups = config.deleteAutomatedBackups;
        this._deletionProtection = config.deletionProtection;
        this._domain = config.domain;
        this._domainIamRoleName = config.domainIamRoleName;
        this._enabledCloudwatchLogsExports = config.enabledCloudwatchLogsExports;
        this._engine = config.engine;
        this._engineVersion = config.engineVersion;
        this._finalSnapshotIdentifier = config.finalSnapshotIdentifier;
        this._iamDatabaseAuthenticationEnabled = config.iamDatabaseAuthenticationEnabled;
        this._identifier = config.identifier;
        this._identifierPrefix = config.identifierPrefix;
        this._instanceClass = config.instanceClass;
        this._iops = config.iops;
        this._kmsKeyId = config.kmsKeyId;
        this._licenseModel = config.licenseModel;
        this._maintenanceWindow = config.maintenanceWindow;
        this._maxAllocatedStorage = config.maxAllocatedStorage;
        this._monitoringInterval = config.monitoringInterval;
        this._monitoringRoleArn = config.monitoringRoleArn;
        this._multiAz = config.multiAz;
        this._name = config.name;
        this._optionGroupName = config.optionGroupName;
        this._parameterGroupName = config.parameterGroupName;
        this._password = config.password;
        this._performanceInsightsEnabled = config.performanceInsightsEnabled;
        this._performanceInsightsKmsKeyId = config.performanceInsightsKmsKeyId;
        this._performanceInsightsRetentionPeriod = config.performanceInsightsRetentionPeriod;
        this._port = config.port;
        this._publiclyAccessible = config.publiclyAccessible;
        this._replicateSourceDb = config.replicateSourceDb;
        this._securityGroupNames = config.securityGroupNames;
        this._skipFinalSnapshot = config.skipFinalSnapshot;
        this._snapshotIdentifier = config.snapshotIdentifier;
        this._storageEncrypted = config.storageEncrypted;
        this._storageType = config.storageType;
        this._tags = config.tags;
        this._timezone = config.timezone;
        this._username = config.username;
        this._vpcSecurityGroupIds = config.vpcSecurityGroupIds;
        this._s3Import = config.s3Import;
        this._timeouts = config.timeouts;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // address - computed: true, optional: false, required: true
    get address() {
        return this.getStringAttribute('address');
    }
    get allocatedStorage() {
        var _a;
        return (_a = this._allocatedStorage) !== null && _a !== void 0 ? _a : this.getNumberAttribute('allocated_storage');
    }
    set allocatedStorage(value) {
        this._allocatedStorage = value;
    }
    get allowMajorVersionUpgrade() {
        return this._allowMajorVersionUpgrade;
    }
    set allowMajorVersionUpgrade(value) {
        this._allowMajorVersionUpgrade = value;
    }
    get applyImmediately() {
        var _a;
        return (_a = this._applyImmediately) !== null && _a !== void 0 ? _a : this.getBooleanAttribute('apply_immediately');
    }
    set applyImmediately(value) {
        this._applyImmediately = value;
    }
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get autoMinorVersionUpgrade() {
        return this._autoMinorVersionUpgrade;
    }
    set autoMinorVersionUpgrade(value) {
        this._autoMinorVersionUpgrade = value;
    }
    get availabilityZone() {
        var _a;
        return (_a = this._availabilityZone) !== null && _a !== void 0 ? _a : this.getStringAttribute('availability_zone');
    }
    set availabilityZone(value) {
        this._availabilityZone = value;
    }
    get backupRetentionPeriod() {
        var _a;
        return (_a = this._backupRetentionPeriod) !== null && _a !== void 0 ? _a : this.getNumberAttribute('backup_retention_period');
    }
    set backupRetentionPeriod(value) {
        this._backupRetentionPeriod = value;
    }
    get backupWindow() {
        var _a;
        return (_a = this._backupWindow) !== null && _a !== void 0 ? _a : this.getStringAttribute('backup_window');
    }
    set backupWindow(value) {
        this._backupWindow = value;
    }
    get caCertIdentifier() {
        var _a;
        return (_a = this._caCertIdentifier) !== null && _a !== void 0 ? _a : this.getStringAttribute('ca_cert_identifier');
    }
    set caCertIdentifier(value) {
        this._caCertIdentifier = value;
    }
    get characterSetName() {
        var _a;
        return (_a = this._characterSetName) !== null && _a !== void 0 ? _a : this.getStringAttribute('character_set_name');
    }
    set characterSetName(value) {
        this._characterSetName = value;
    }
    get copyTagsToSnapshot() {
        return this._copyTagsToSnapshot;
    }
    set copyTagsToSnapshot(value) {
        this._copyTagsToSnapshot = value;
    }
    get dbSubnetGroupName() {
        var _a;
        return (_a = this._dbSubnetGroupName) !== null && _a !== void 0 ? _a : this.getStringAttribute('db_subnet_group_name');
    }
    set dbSubnetGroupName(value) {
        this._dbSubnetGroupName = value;
    }
    get deleteAutomatedBackups() {
        return this._deleteAutomatedBackups;
    }
    set deleteAutomatedBackups(value) {
        this._deleteAutomatedBackups = value;
    }
    get deletionProtection() {
        return this._deletionProtection;
    }
    set deletionProtection(value) {
        this._deletionProtection = value;
    }
    get domain() {
        return this._domain;
    }
    set domain(value) {
        this._domain = value;
    }
    get domainIamRoleName() {
        return this._domainIamRoleName;
    }
    set domainIamRoleName(value) {
        this._domainIamRoleName = value;
    }
    get enabledCloudwatchLogsExports() {
        return this._enabledCloudwatchLogsExports;
    }
    set enabledCloudwatchLogsExports(value) {
        this._enabledCloudwatchLogsExports = value;
    }
    // endpoint - computed: true, optional: false, required: true
    get endpoint() {
        return this.getStringAttribute('endpoint');
    }
    get engine() {
        var _a;
        return (_a = this._engine) !== null && _a !== void 0 ? _a : this.getStringAttribute('engine');
    }
    set engine(value) {
        this._engine = value;
    }
    get engineVersion() {
        var _a;
        return (_a = this._engineVersion) !== null && _a !== void 0 ? _a : this.getStringAttribute('engine_version');
    }
    set engineVersion(value) {
        this._engineVersion = value;
    }
    get finalSnapshotIdentifier() {
        return this._finalSnapshotIdentifier;
    }
    set finalSnapshotIdentifier(value) {
        this._finalSnapshotIdentifier = value;
    }
    // hosted_zone_id - computed: true, optional: false, required: true
    get hostedZoneId() {
        return this.getStringAttribute('hosted_zone_id');
    }
    get iamDatabaseAuthenticationEnabled() {
        return this._iamDatabaseAuthenticationEnabled;
    }
    set iamDatabaseAuthenticationEnabled(value) {
        this._iamDatabaseAuthenticationEnabled = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get identifier() {
        var _a;
        return (_a = this._identifier) !== null && _a !== void 0 ? _a : this.getStringAttribute('identifier');
    }
    set identifier(value) {
        this._identifier = value;
    }
    get identifierPrefix() {
        var _a;
        return (_a = this._identifierPrefix) !== null && _a !== void 0 ? _a : this.getStringAttribute('identifier_prefix');
    }
    set identifierPrefix(value) {
        this._identifierPrefix = value;
    }
    get instanceClass() {
        return this._instanceClass;
    }
    set instanceClass(value) {
        this._instanceClass = value;
    }
    get iops() {
        return this._iops;
    }
    set iops(value) {
        this._iops = value;
    }
    get kmsKeyId() {
        var _a;
        return (_a = this._kmsKeyId) !== null && _a !== void 0 ? _a : this.getStringAttribute('kms_key_id');
    }
    set kmsKeyId(value) {
        this._kmsKeyId = value;
    }
    get licenseModel() {
        var _a;
        return (_a = this._licenseModel) !== null && _a !== void 0 ? _a : this.getStringAttribute('license_model');
    }
    set licenseModel(value) {
        this._licenseModel = value;
    }
    get maintenanceWindow() {
        var _a;
        return (_a = this._maintenanceWindow) !== null && _a !== void 0 ? _a : this.getStringAttribute('maintenance_window');
    }
    set maintenanceWindow(value) {
        this._maintenanceWindow = value;
    }
    get maxAllocatedStorage() {
        return this._maxAllocatedStorage;
    }
    set maxAllocatedStorage(value) {
        this._maxAllocatedStorage = value;
    }
    get monitoringInterval() {
        return this._monitoringInterval;
    }
    set monitoringInterval(value) {
        this._monitoringInterval = value;
    }
    get monitoringRoleArn() {
        var _a;
        return (_a = this._monitoringRoleArn) !== null && _a !== void 0 ? _a : this.getStringAttribute('monitoring_role_arn');
    }
    set monitoringRoleArn(value) {
        this._monitoringRoleArn = value;
    }
    get multiAz() {
        var _a;
        return (_a = this._multiAz) !== null && _a !== void 0 ? _a : this.getBooleanAttribute('multi_az');
    }
    set multiAz(value) {
        this._multiAz = value;
    }
    get name() {
        var _a;
        return (_a = this._name) !== null && _a !== void 0 ? _a : this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    get optionGroupName() {
        var _a;
        return (_a = this._optionGroupName) !== null && _a !== void 0 ? _a : this.getStringAttribute('option_group_name');
    }
    set optionGroupName(value) {
        this._optionGroupName = value;
    }
    get parameterGroupName() {
        var _a;
        return (_a = this._parameterGroupName) !== null && _a !== void 0 ? _a : this.getStringAttribute('parameter_group_name');
    }
    set parameterGroupName(value) {
        this._parameterGroupName = value;
    }
    get password() {
        return this._password;
    }
    set password(value) {
        this._password = value;
    }
    get performanceInsightsEnabled() {
        return this._performanceInsightsEnabled;
    }
    set performanceInsightsEnabled(value) {
        this._performanceInsightsEnabled = value;
    }
    get performanceInsightsKmsKeyId() {
        var _a;
        return (_a = this._performanceInsightsKmsKeyId) !== null && _a !== void 0 ? _a : this.getStringAttribute('performance_insights_kms_key_id');
    }
    set performanceInsightsKmsKeyId(value) {
        this._performanceInsightsKmsKeyId = value;
    }
    get performanceInsightsRetentionPeriod() {
        var _a;
        return (_a = this._performanceInsightsRetentionPeriod) !== null && _a !== void 0 ? _a : this.getNumberAttribute('performance_insights_retention_period');
    }
    set performanceInsightsRetentionPeriod(value) {
        this._performanceInsightsRetentionPeriod = value;
    }
    get port() {
        var _a;
        return (_a = this._port) !== null && _a !== void 0 ? _a : this.getNumberAttribute('port');
    }
    set port(value) {
        this._port = value;
    }
    get publiclyAccessible() {
        return this._publiclyAccessible;
    }
    set publiclyAccessible(value) {
        this._publiclyAccessible = value;
    }
    // replicas - computed: true, optional: false, required: true
    get replicas() {
        return this.getListAttribute('replicas');
    }
    get replicateSourceDb() {
        return this._replicateSourceDb;
    }
    set replicateSourceDb(value) {
        this._replicateSourceDb = value;
    }
    // resource_id - computed: true, optional: false, required: true
    get resourceId() {
        return this.getStringAttribute('resource_id');
    }
    get securityGroupNames() {
        return this._securityGroupNames;
    }
    set securityGroupNames(value) {
        this._securityGroupNames = value;
    }
    get skipFinalSnapshot() {
        return this._skipFinalSnapshot;
    }
    set skipFinalSnapshot(value) {
        this._skipFinalSnapshot = value;
    }
    get snapshotIdentifier() {
        return this._snapshotIdentifier;
    }
    set snapshotIdentifier(value) {
        this._snapshotIdentifier = value;
    }
    // status - computed: true, optional: false, required: true
    get status() {
        return this.getStringAttribute('status');
    }
    get storageEncrypted() {
        return this._storageEncrypted;
    }
    set storageEncrypted(value) {
        this._storageEncrypted = value;
    }
    get storageType() {
        var _a;
        return (_a = this._storageType) !== null && _a !== void 0 ? _a : this.getStringAttribute('storage_type');
    }
    set storageType(value) {
        this._storageType = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get timezone() {
        var _a;
        return (_a = this._timezone) !== null && _a !== void 0 ? _a : this.getStringAttribute('timezone');
    }
    set timezone(value) {
        this._timezone = value;
    }
    get username() {
        var _a;
        return (_a = this._username) !== null && _a !== void 0 ? _a : this.getStringAttribute('username');
    }
    set username(value) {
        this._username = value;
    }
    get vpcSecurityGroupIds() {
        var _a;
        return (_a = this._vpcSecurityGroupIds) !== null && _a !== void 0 ? _a : this.getListAttribute('vpc_security_group_ids');
    }
    set vpcSecurityGroupIds(value) {
        this._vpcSecurityGroupIds = value;
    }
    get s3Import() {
        return this._s3Import;
    }
    set s3Import(value) {
        this._s3Import = value;
    }
    get timeouts() {
        return this._timeouts;
    }
    set timeouts(value) {
        this._timeouts = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allocated_storage: this._allocatedStorage,
            allow_major_version_upgrade: this._allowMajorVersionUpgrade,
            apply_immediately: this._applyImmediately,
            auto_minor_version_upgrade: this._autoMinorVersionUpgrade,
            availability_zone: this._availabilityZone,
            backup_retention_period: this._backupRetentionPeriod,
            backup_window: this._backupWindow,
            ca_cert_identifier: this._caCertIdentifier,
            character_set_name: this._characterSetName,
            copy_tags_to_snapshot: this._copyTagsToSnapshot,
            db_subnet_group_name: this._dbSubnetGroupName,
            delete_automated_backups: this._deleteAutomatedBackups,
            deletion_protection: this._deletionProtection,
            domain: this._domain,
            domain_iam_role_name: this._domainIamRoleName,
            enabled_cloudwatch_logs_exports: this._enabledCloudwatchLogsExports,
            engine: this._engine,
            engine_version: this._engineVersion,
            final_snapshot_identifier: this._finalSnapshotIdentifier,
            iam_database_authentication_enabled: this._iamDatabaseAuthenticationEnabled,
            identifier: this._identifier,
            identifier_prefix: this._identifierPrefix,
            instance_class: this._instanceClass,
            iops: this._iops,
            kms_key_id: this._kmsKeyId,
            license_model: this._licenseModel,
            maintenance_window: this._maintenanceWindow,
            max_allocated_storage: this._maxAllocatedStorage,
            monitoring_interval: this._monitoringInterval,
            monitoring_role_arn: this._monitoringRoleArn,
            multi_az: this._multiAz,
            name: this._name,
            option_group_name: this._optionGroupName,
            parameter_group_name: this._parameterGroupName,
            password: this._password,
            performance_insights_enabled: this._performanceInsightsEnabled,
            performance_insights_kms_key_id: this._performanceInsightsKmsKeyId,
            performance_insights_retention_period: this._performanceInsightsRetentionPeriod,
            port: this._port,
            publicly_accessible: this._publiclyAccessible,
            replicate_source_db: this._replicateSourceDb,
            security_group_names: this._securityGroupNames,
            skip_final_snapshot: this._skipFinalSnapshot,
            snapshot_identifier: this._snapshotIdentifier,
            storage_encrypted: this._storageEncrypted,
            storage_type: this._storageType,
            tags: this._tags,
            timezone: this._timezone,
            username: this._username,
            vpc_security_group_ids: this._vpcSecurityGroupIds,
            s3_import: this._s3Import,
            timeouts: this._timeouts,
        };
    }
}
exports.DbInstance = DbInstance;
//# sourceMappingURL=data:application/json;base64,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