import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DbOptionGroupConfig extends TerraformMetaArguments {
    readonly engineName: string;
    readonly majorEngineVersion: string;
    readonly name?: string;
    readonly namePrefix?: string;
    readonly optionGroupDescription?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** option block */
    readonly option?: DbOptionGroupOption[];
    /** timeouts block */
    readonly timeouts?: DbOptionGroupTimeouts;
}
export interface DbOptionGroupOptionOptionSettings {
    readonly name: string;
    readonly value: string;
}
export interface DbOptionGroupOption {
    readonly dbSecurityGroupMemberships?: string[];
    readonly optionName: string;
    readonly port?: number;
    readonly version?: string;
    readonly vpcSecurityGroupMemberships?: string[];
    /** option_settings block */
    readonly optionSettings?: DbOptionGroupOptionOptionSettings[];
}
export interface DbOptionGroupTimeouts {
    readonly delete?: string;
}
export declare class DbOptionGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config: DbOptionGroupConfig);
    get arn(): string;
    private _engineName;
    get engineName(): string;
    set engineName(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _majorEngineVersion;
    get majorEngineVersion(): string;
    set majorEngineVersion(value: string);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _optionGroupDescription?;
    get optionGroupDescription(): string | undefined;
    set optionGroupDescription(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _option?;
    get option(): DbOptionGroupOption[] | undefined;
    set option(value: DbOptionGroupOption[] | undefined);
    private _timeouts?;
    get timeouts(): DbOptionGroupTimeouts | undefined;
    set timeouts(value: DbOptionGroupTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
