import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DbParameterGroupConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly family: string;
    readonly name?: string;
    readonly namePrefix?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** parameter block */
    readonly parameter?: DbParameterGroupParameter[];
}
export interface DbParameterGroupParameter {
    readonly applyMethod?: string;
    readonly name: string;
    readonly value: string;
}
export declare class DbParameterGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config: DbParameterGroupConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _family;
    get family(): string;
    set family(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _parameter?;
    get parameter(): DbParameterGroupParameter[] | undefined;
    set parameter(value: DbParameterGroupParameter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
