import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DbSecurityGroupConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** ingress block */
    readonly ingress: DbSecurityGroupIngress[];
}
export interface DbSecurityGroupIngress {
    readonly cidr?: string;
    readonly securityGroupId?: string;
    readonly securityGroupName?: string;
    readonly securityGroupOwnerId?: string;
}
export declare class DbSecurityGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config: DbSecurityGroupConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _ingress;
    get ingress(): DbSecurityGroupIngress[];
    set ingress(value: DbSecurityGroupIngress[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
