import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DbSnapshotConfig extends TerraformMetaArguments {
    readonly dbInstanceIdentifier: string;
    readonly dbSnapshotIdentifier: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** timeouts block */
    readonly timeouts?: DbSnapshotTimeouts;
}
export interface DbSnapshotTimeouts {
    readonly read?: string;
}
export declare class DbSnapshot extends TerraformResource {
    constructor(scope: Construct, id: string, config: DbSnapshotConfig);
    get allocatedStorage(): number;
    get availabilityZone(): string;
    private _dbInstanceIdentifier;
    get dbInstanceIdentifier(): string;
    set dbInstanceIdentifier(value: string);
    get dbSnapshotArn(): string;
    private _dbSnapshotIdentifier;
    get dbSnapshotIdentifier(): string;
    set dbSnapshotIdentifier(value: string);
    get encrypted(): boolean;
    get engine(): string;
    get engineVersion(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get iops(): number;
    get kmsKeyId(): string;
    get licenseModel(): string;
    get optionGroupName(): string;
    get port(): number;
    get snapshotType(): string;
    get sourceDbSnapshotIdentifier(): string;
    get sourceRegion(): string;
    get status(): string;
    get storageType(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get vpcId(): string;
    private _timeouts?;
    get timeouts(): DbSnapshotTimeouts | undefined;
    set timeouts(value: DbSnapshotTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
