import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DefaultNetworkAclConfig extends TerraformMetaArguments {
    readonly defaultNetworkAclId: string;
    readonly subnetIds?: string[];
    readonly tags?: {
        [key: string]: string;
    };
    /** egress block */
    readonly egress?: DefaultNetworkAclEgress[];
    /** ingress block */
    readonly ingress?: DefaultNetworkAclIngress[];
}
export interface DefaultNetworkAclEgress {
    readonly action: string;
    readonly cidrBlock?: string;
    readonly fromPort: number;
    readonly icmpCode?: number;
    readonly icmpType?: number;
    readonly ipv6CidrBlock?: string;
    readonly protocol: string;
    readonly ruleNo: number;
    readonly toPort: number;
}
export interface DefaultNetworkAclIngress {
    readonly action: string;
    readonly cidrBlock?: string;
    readonly fromPort: number;
    readonly icmpCode?: number;
    readonly icmpType?: number;
    readonly ipv6CidrBlock?: string;
    readonly protocol: string;
    readonly ruleNo: number;
    readonly toPort: number;
}
export declare class DefaultNetworkAcl extends TerraformResource {
    constructor(scope: Construct, id: string, config: DefaultNetworkAclConfig);
    get arn(): string;
    private _defaultNetworkAclId;
    get defaultNetworkAclId(): string;
    set defaultNetworkAclId(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get ownerId(): string;
    private _subnetIds?;
    get subnetIds(): string[] | undefined;
    set subnetIds(value: string[] | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get vpcId(): string;
    private _egress?;
    get egress(): DefaultNetworkAclEgress[] | undefined;
    set egress(value: DefaultNetworkAclEgress[] | undefined);
    private _ingress?;
    get ingress(): DefaultNetworkAclIngress[] | undefined;
    set ingress(value: DefaultNetworkAclIngress[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
