import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DefaultRouteTableConfig extends TerraformMetaArguments {
    readonly defaultRouteTableId: string;
    readonly propagatingVgws?: string[];
    readonly route?: DefaultRouteTableRoute[];
    readonly tags?: {
        [key: string]: string;
    };
}
export interface DefaultRouteTableRoute {
    readonly cidrBlock?: string;
    readonly egressOnlyGatewayId?: string;
    readonly gatewayId?: string;
    readonly instanceId?: string;
    readonly ipv6CidrBlock?: string;
    readonly natGatewayId?: string;
    readonly networkInterfaceId?: string;
    readonly transitGatewayId?: string;
    readonly vpcPeeringConnectionId?: string;
}
export declare class DefaultRouteTable extends TerraformResource {
    constructor(scope: Construct, id: string, config: DefaultRouteTableConfig);
    private _defaultRouteTableId;
    get defaultRouteTableId(): string;
    set defaultRouteTableId(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get ownerId(): string;
    private _propagatingVgws?;
    get propagatingVgws(): string[] | undefined;
    set propagatingVgws(value: string[] | undefined);
    private _route?;
    get route(): DefaultRouteTableRoute[] | undefined;
    set route(value: DefaultRouteTableRoute[] | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get vpcId(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
