"use strict";
// https://www.terraform.io/docs/providers/aws/r/default_route_table.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultRouteTable = void 0;
const cdktf_1 = require("cdktf");
// Resource
class DefaultRouteTable extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_default_route_table',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._defaultRouteTableId = config.defaultRouteTableId;
        this._propagatingVgws = config.propagatingVgws;
        this._route = config.route;
        this._tags = config.tags;
    }
    get defaultRouteTableId() {
        return this._defaultRouteTableId;
    }
    set defaultRouteTableId(value) {
        this._defaultRouteTableId = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    // owner_id - computed: true, optional: false, required: true
    get ownerId() {
        return this.getStringAttribute('owner_id');
    }
    get propagatingVgws() {
        return this._propagatingVgws;
    }
    set propagatingVgws(value) {
        this._propagatingVgws = value;
    }
    get route() {
        return this._route; // Getting the computed value is not yet implemented
    }
    set route(value) {
        this._route = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    // vpc_id - computed: true, optional: false, required: true
    get vpcId() {
        return this.getStringAttribute('vpc_id');
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            default_route_table_id: this._defaultRouteTableId,
            propagating_vgws: this._propagatingVgws,
            route: this._route,
            tags: this._tags,
        };
    }
}
exports.DefaultRouteTable = DefaultRouteTable;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVmYXVsdC1yb3V0ZS10YWJsZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9kZWZhdWx0LXJvdXRlLXRhYmxlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSx5RUFBeUU7QUFDekUsMkNBQTJDOzs7QUFnRTNDLGlDQUEwQztBQXVCMUMsV0FBVztBQUVYLE1BQWEsaUJBQWtCLFNBQVEseUJBQWlCO0lBRXRELGNBQWM7SUFDZCxjQUFjO0lBQ2QsY0FBYztJQUVkLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLE1BQStCO1FBQzlFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YscUJBQXFCLEVBQUUseUJBQXlCO1lBQ2hELDBCQUEwQixFQUFFO2dCQUMxQixZQUFZLEVBQUUsS0FBSzthQUNwQjtZQUNELFFBQVEsRUFBRSxNQUFNLENBQUMsUUFBUTtZQUN6QixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7WUFDM0IsS0FBSyxFQUFFLE1BQU0sQ0FBQyxLQUFLO1lBQ25CLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztTQUM1QixDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsTUFBTSxDQUFDLG1CQUFtQixDQUFDO1FBQ3ZELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxNQUFNLENBQUMsZUFBZSxDQUFDO1FBQy9DLElBQUksQ0FBQyxNQUFNLEdBQUcsTUFBTSxDQUFDLEtBQUssQ0FBQztRQUMzQixJQUFJLENBQUMsS0FBSyxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUM7SUFDM0IsQ0FBQztJQVFELElBQVcsbUJBQW1CO1FBQzVCLE9BQU8sSUFBSSxDQUFDLG9CQUFvQixDQUFDO0lBQ25DLENBQUM7SUFDRCxJQUFXLG1CQUFtQixDQUFDLEtBQWE7UUFDMUMsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQztJQUNwQyxDQUFDO0lBSUQsSUFBVyxFQUFFOztRQUNYLGFBQU8sSUFBSSxDQUFDLEdBQUcsbUNBQUksSUFBSSxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxDQUFDO0lBQ25ELENBQUM7SUFDRCxJQUFXLEVBQUUsQ0FBQyxLQUF5QjtRQUNyQyxJQUFJLENBQUMsR0FBRyxHQUFHLEtBQUssQ0FBQztJQUNuQixDQUFDO0lBRUQsNkRBQTZEO0lBQzdELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBSUQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDO0lBQy9CLENBQUM7SUFDRCxJQUFXLGVBQWUsQ0FBQyxLQUEyQjtRQUNwRCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDO0lBQ2hDLENBQUM7SUFJRCxJQUFXLEtBQUs7UUFDZCxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQyxvREFBb0Q7SUFDMUUsQ0FBQztJQUNELElBQVcsS0FBSyxDQUFDLEtBQTJDO1FBQzFELElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDO0lBQ3RCLENBQUM7SUFJRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQTRDO1FBQzFELElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0lBQ3JCLENBQUM7SUFFRCwyREFBMkQ7SUFDM0QsSUFBVyxLQUFLO1FBQ2QsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUVELFlBQVk7SUFDWixZQUFZO0lBQ1osWUFBWTtJQUVMLG9CQUFvQjtRQUN6QixPQUFPO1lBQ0wsc0JBQXNCLEVBQUUsSUFBSSxDQUFDLG9CQUFvQjtZQUNqRCxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsZ0JBQWdCO1lBQ3ZDLEtBQUssRUFBRSxJQUFJLENBQUMsTUFBTTtZQUNsQixJQUFJLEVBQUUsSUFBSSxDQUFDLEtBQUs7U0FDakIsQ0FBQztJQUNKLENBQUM7Q0FDRjtBQTlGRCw4Q0E4RkMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXdzL3IvZGVmYXVsdF9yb3V0ZV90YWJsZS5odG1sXG4vLyBnZW5lcmF0ZWQgZnJvbSB0ZXJyYWZvcm0gcmVzb3VyY2Ugc2NoZW1hXG5cbi8qXG57XG4gIFwidmVyc2lvblwiOiAwLFxuICBcImJsb2NrXCI6IHtcbiAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgXCJkZWZhdWx0X3JvdXRlX3RhYmxlX2lkXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiaWRcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcIm93bmVyX2lkXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwicHJvcGFnYXRpbmdfdmd3c1wiOiB7XG4gICAgICAgIFwidHlwZVwiOiBbXG4gICAgICAgICAgXCJzZXRcIixcbiAgICAgICAgICBcInN0cmluZ1wiXG4gICAgICAgIF0sXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwicm91dGVcIjoge1xuICAgICAgICBcInR5cGVcIjogW1xuICAgICAgICAgIFwic2V0XCIsXG4gICAgICAgICAgW1xuICAgICAgICAgICAgXCJvYmplY3RcIixcbiAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgXCJjaWRyX2Jsb2NrXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwiZWdyZXNzX29ubHlfZ2F0ZXdheV9pZFwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcImdhdGV3YXlfaWRcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJpbnN0YW5jZV9pZFwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcImlwdjZfY2lkcl9ibG9ja1wiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcIm5hdF9nYXRld2F5X2lkXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwibmV0d29ya19pbnRlcmZhY2VfaWRcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJ0cmFuc2l0X2dhdGV3YXlfaWRcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJ2cGNfcGVlcmluZ19jb25uZWN0aW9uX2lkXCI6IFwic3RyaW5nXCJcbiAgICAgICAgICAgIH1cbiAgICAgICAgICBdXG4gICAgICAgIF0sXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZSxcbiAgICAgICAgXCJjb21wdXRlZFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJ0YWdzXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFtcbiAgICAgICAgICBcIm1hcFwiLFxuICAgICAgICAgIFwic3RyaW5nXCJcbiAgICAgICAgXSxcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJ2cGNfaWRcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJjb21wdXRlZFwiOiB0cnVlXG4gICAgICB9XG4gICAgfVxuICB9XG59XG4qL1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBUZXJyYWZvcm1SZXNvdXJjZSB9IGZyb20gJ2Nka3RmJztcbmltcG9ydCB7IFRlcnJhZm9ybU1ldGFBcmd1bWVudHMgfSBmcm9tICdjZGt0Zic7XG5cbi8vIENvbmZpZ3VyYXRpb25cblxuZXhwb3J0IGludGVyZmFjZSBEZWZhdWx0Um91dGVUYWJsZUNvbmZpZyBleHRlbmRzIFRlcnJhZm9ybU1ldGFBcmd1bWVudHMge1xuICByZWFkb25seSBkZWZhdWx0Um91dGVUYWJsZUlkOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHByb3BhZ2F0aW5nVmd3cz86IHN0cmluZ1tdO1xuICByZWFkb25seSByb3V0ZT86IERlZmF1bHRSb3V0ZVRhYmxlUm91dGVbXTtcbiAgcmVhZG9ubHkgdGFncz86IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH07XG59XG5leHBvcnQgaW50ZXJmYWNlIERlZmF1bHRSb3V0ZVRhYmxlUm91dGUge1xuICByZWFkb25seSBjaWRyQmxvY2s/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGVncmVzc09ubHlHYXRld2F5SWQ/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGdhdGV3YXlJZD86IHN0cmluZztcbiAgcmVhZG9ubHkgaW5zdGFuY2VJZD86IHN0cmluZztcbiAgcmVhZG9ubHkgaXB2NkNpZHJCbG9jaz86IHN0cmluZztcbiAgcmVhZG9ubHkgbmF0R2F0ZXdheUlkPzogc3RyaW5nO1xuICByZWFkb25seSBuZXR3b3JrSW50ZXJmYWNlSWQ/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHRyYW5zaXRHYXRld2F5SWQ/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHZwY1BlZXJpbmdDb25uZWN0aW9uSWQ/OiBzdHJpbmc7XG59XG5cbi8vIFJlc291cmNlXG5cbmV4cG9ydCBjbGFzcyBEZWZhdWx0Um91dGVUYWJsZSBleHRlbmRzIFRlcnJhZm9ybVJlc291cmNlIHtcblxuICAvLyA9PT09PT09PT09PVxuICAvLyBJTklUSUFMSVpFUlxuICAvLyA9PT09PT09PT09PVxuXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBjb25maWc6IERlZmF1bHRSb3V0ZVRhYmxlQ29uZmlnKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICB0ZXJyYWZvcm1SZXNvdXJjZVR5cGU6ICdhd3NfZGVmYXVsdF9yb3V0ZV90YWJsZScsXG4gICAgICB0ZXJyYWZvcm1HZW5lcmF0b3JNZXRhZGF0YToge1xuICAgICAgICBwcm92aWRlck5hbWU6ICdhd3MnXG4gICAgICB9LFxuICAgICAgcHJvdmlkZXI6IGNvbmZpZy5wcm92aWRlcixcbiAgICAgIGRlcGVuZHNPbjogY29uZmlnLmRlcGVuZHNPbixcbiAgICAgIGNvdW50OiBjb25maWcuY291bnQsXG4gICAgICBsaWZlY3ljbGU6IGNvbmZpZy5saWZlY3ljbGVcbiAgICB9KTtcbiAgICB0aGlzLl9kZWZhdWx0Um91dGVUYWJsZUlkID0gY29uZmlnLmRlZmF1bHRSb3V0ZVRhYmxlSWQ7XG4gICAgdGhpcy5fcHJvcGFnYXRpbmdWZ3dzID0gY29uZmlnLnByb3BhZ2F0aW5nVmd3cztcbiAgICB0aGlzLl9yb3V0ZSA9IGNvbmZpZy5yb3V0ZTtcbiAgICB0aGlzLl90YWdzID0gY29uZmlnLnRhZ3M7XG4gIH1cblxuICAvLyA9PT09PT09PT09XG4gIC8vIEFUVFJJQlVURVNcbiAgLy8gPT09PT09PT09PVxuXG4gIC8vIGRlZmF1bHRfcm91dGVfdGFibGVfaWQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfZGVmYXVsdFJvdXRlVGFibGVJZDogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IGRlZmF1bHRSb3V0ZVRhYmxlSWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2RlZmF1bHRSb3V0ZVRhYmxlSWQ7XG4gIH1cbiAgcHVibGljIHNldCBkZWZhdWx0Um91dGVUYWJsZUlkKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9kZWZhdWx0Um91dGVUYWJsZUlkID0gdmFsdWU7XG4gIH1cblxuICAvLyBpZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2lkPzogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IGlkKCkge1xuICAgIHJldHVybiB0aGlzLl9pZCA/PyB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnaWQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGlkKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9pZCA9IHZhbHVlO1xuICB9XG5cbiAgLy8gb3duZXJfaWQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwdWJsaWMgZ2V0IG93bmVySWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdvd25lcl9pZCcpO1xuICB9XG5cbiAgLy8gcHJvcGFnYXRpbmdfdmd3cyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9wcm9wYWdhdGluZ1Znd3M/OiBzdHJpbmdbXTtcbiAgcHVibGljIGdldCBwcm9wYWdhdGluZ1Znd3MoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Byb3BhZ2F0aW5nVmd3cztcbiAgfVxuICBwdWJsaWMgc2V0IHByb3BhZ2F0aW5nVmd3cyh2YWx1ZTogc3RyaW5nW10gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9wcm9wYWdhdGluZ1Znd3MgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHJvdXRlIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcm91dGU/OiBEZWZhdWx0Um91dGVUYWJsZVJvdXRlW11cbiAgcHVibGljIGdldCByb3V0ZSgpOiBEZWZhdWx0Um91dGVUYWJsZVJvdXRlW10gfCB1bmRlZmluZWQge1xuICAgIHJldHVybiB0aGlzLl9yb3V0ZTsgLy8gR2V0dGluZyB0aGUgY29tcHV0ZWQgdmFsdWUgaXMgbm90IHlldCBpbXBsZW1lbnRlZFxuICB9XG4gIHB1YmxpYyBzZXQgcm91dGUodmFsdWU6IERlZmF1bHRSb3V0ZVRhYmxlUm91dGVbXSB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX3JvdXRlID0gdmFsdWU7XG4gIH1cblxuICAvLyB0YWdzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3RhZ3M/OiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9O1xuICBwdWJsaWMgZ2V0IHRhZ3MoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3RhZ3M7XG4gIH1cbiAgcHVibGljIHNldCB0YWdzKHZhbHVlOiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9IHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fdGFncyA9IHZhbHVlO1xuICB9XG5cbiAgLy8gdnBjX2lkIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHVibGljIGdldCB2cGNJZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3ZwY19pZCcpO1xuICB9XG5cbiAgLy8gPT09PT09PT09XG4gIC8vIFNZTlRIRVNJU1xuICAvLyA9PT09PT09PT1cblxuICBwdWJsaWMgc3ludGhlc2l6ZUF0dHJpYnV0ZXMoKTogeyBbbmFtZTogc3RyaW5nXTogYW55IH0ge1xuICAgIHJldHVybiB7XG4gICAgICBkZWZhdWx0X3JvdXRlX3RhYmxlX2lkOiB0aGlzLl9kZWZhdWx0Um91dGVUYWJsZUlkLFxuICAgICAgcHJvcGFnYXRpbmdfdmd3czogdGhpcy5fcHJvcGFnYXRpbmdWZ3dzLFxuICAgICAgcm91dGU6IHRoaXMuX3JvdXRlLFxuICAgICAgdGFnczogdGhpcy5fdGFncyxcbiAgICB9O1xuICB9XG59XG4iXX0=