import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DefaultSecurityGroupConfig extends TerraformMetaArguments {
    readonly egress?: DefaultSecurityGroupEgress[];
    readonly ingress?: DefaultSecurityGroupIngress[];
    readonly revokeRulesOnDelete?: boolean;
    readonly tags?: {
        [key: string]: string;
    };
    readonly vpcId?: string;
    /** timeouts block */
    readonly timeouts?: DefaultSecurityGroupTimeouts;
}
export interface DefaultSecurityGroupEgress {
    readonly cidrBlocks?: string[];
    readonly description?: string;
    readonly fromPort?: number;
    readonly ipv6CidrBlocks?: string[];
    readonly prefixListIds?: string[];
    readonly protocol?: string;
    readonly securityGroups?: string[];
    readonly selfAttribute?: boolean;
    readonly toPort?: number;
}
export interface DefaultSecurityGroupIngress {
    readonly cidrBlocks?: string[];
    readonly description?: string;
    readonly fromPort?: number;
    readonly ipv6CidrBlocks?: string[];
    readonly prefixListIds?: string[];
    readonly protocol?: string;
    readonly securityGroups?: string[];
    readonly selfAttribute?: boolean;
    readonly toPort?: number;
}
export interface DefaultSecurityGroupTimeouts {
    readonly create?: string;
    readonly delete?: string;
}
export declare class DefaultSecurityGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config?: DefaultSecurityGroupConfig);
    get arn(): string;
    get description(): string;
    private _egress?;
    get egress(): DefaultSecurityGroupEgress[] | undefined;
    set egress(value: DefaultSecurityGroupEgress[] | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _ingress?;
    get ingress(): DefaultSecurityGroupIngress[] | undefined;
    set ingress(value: DefaultSecurityGroupIngress[] | undefined);
    get name(): string;
    get ownerId(): string;
    private _revokeRulesOnDelete?;
    get revokeRulesOnDelete(): boolean | undefined;
    set revokeRulesOnDelete(value: boolean | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _vpcId?;
    get vpcId(): string | undefined;
    set vpcId(value: string | undefined);
    private _timeouts?;
    get timeouts(): DefaultSecurityGroupTimeouts | undefined;
    set timeouts(value: DefaultSecurityGroupTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
