import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DefaultSubnetConfig extends TerraformMetaArguments {
    readonly availabilityZone: string;
    readonly mapPublicIpOnLaunch?: boolean;
    readonly outpostArn?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** timeouts block */
    readonly timeouts?: DefaultSubnetTimeouts;
}
export interface DefaultSubnetTimeouts {
    readonly create?: string;
    readonly delete?: string;
}
export declare class DefaultSubnet extends TerraformResource {
    constructor(scope: Construct, id: string, config: DefaultSubnetConfig);
    get arn(): string;
    get assignIpv6AddressOnCreation(): boolean;
    private _availabilityZone;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    get availabilityZoneId(): string;
    get cidrBlock(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get ipv6CidrBlock(): string;
    get ipv6CidrBlockAssociationId(): string;
    private _mapPublicIpOnLaunch?;
    get mapPublicIpOnLaunch(): boolean | undefined;
    set mapPublicIpOnLaunch(value: boolean | undefined);
    private _outpostArn?;
    get outpostArn(): string | undefined;
    set outpostArn(value: string | undefined);
    get ownerId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get vpcId(): string;
    private _timeouts?;
    get timeouts(): DefaultSubnetTimeouts | undefined;
    set timeouts(value: DefaultSubnetTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
