"use strict";
// https://www.terraform.io/docs/providers/aws/r/default_subnet.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultSubnet = void 0;
const cdktf_1 = require("cdktf");
// Resource
class DefaultSubnet extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_default_subnet',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._availabilityZone = config.availabilityZone;
        this._mapPublicIpOnLaunch = config.mapPublicIpOnLaunch;
        this._outpostArn = config.outpostArn;
        this._tags = config.tags;
        this._timeouts = config.timeouts;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    // assign_ipv6_address_on_creation - computed: true, optional: false, required: true
    get assignIpv6AddressOnCreation() {
        return this.getBooleanAttribute('assign_ipv6_address_on_creation');
    }
    get availabilityZone() {
        return this._availabilityZone;
    }
    set availabilityZone(value) {
        this._availabilityZone = value;
    }
    // availability_zone_id - computed: true, optional: false, required: true
    get availabilityZoneId() {
        return this.getStringAttribute('availability_zone_id');
    }
    // cidr_block - computed: true, optional: false, required: true
    get cidrBlock() {
        return this.getStringAttribute('cidr_block');
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    // ipv6_cidr_block - computed: true, optional: false, required: true
    get ipv6CidrBlock() {
        return this.getStringAttribute('ipv6_cidr_block');
    }
    // ipv6_cidr_block_association_id - computed: true, optional: false, required: true
    get ipv6CidrBlockAssociationId() {
        return this.getStringAttribute('ipv6_cidr_block_association_id');
    }
    get mapPublicIpOnLaunch() {
        var _a;
        return (_a = this._mapPublicIpOnLaunch) !== null && _a !== void 0 ? _a : this.getBooleanAttribute('map_public_ip_on_launch');
    }
    set mapPublicIpOnLaunch(value) {
        this._mapPublicIpOnLaunch = value;
    }
    get outpostArn() {
        return this._outpostArn;
    }
    set outpostArn(value) {
        this._outpostArn = value;
    }
    // owner_id - computed: true, optional: false, required: true
    get ownerId() {
        return this.getStringAttribute('owner_id');
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    // vpc_id - computed: true, optional: false, required: true
    get vpcId() {
        return this.getStringAttribute('vpc_id');
    }
    get timeouts() {
        return this._timeouts;
    }
    set timeouts(value) {
        this._timeouts = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            availability_zone: this._availabilityZone,
            map_public_ip_on_launch: this._mapPublicIpOnLaunch,
            outpost_arn: this._outpostArn,
            tags: this._tags,
            timeouts: this._timeouts,
        };
    }
}
exports.DefaultSubnet = DefaultSubnet;
//# sourceMappingURL=data:application/json;base64,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