import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DefaultVpcConfig extends TerraformMetaArguments {
    readonly enableClassiclink?: boolean;
    readonly enableClassiclinkDnsSupport?: boolean;
    readonly enableDnsHostnames?: boolean;
    readonly enableDnsSupport?: boolean;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DefaultVpc extends TerraformResource {
    constructor(scope: Construct, id: string, config?: DefaultVpcConfig);
    get arn(): string;
    get assignGeneratedIpv6CidrBlock(): boolean;
    get cidrBlock(): string;
    get defaultNetworkAclId(): string;
    get defaultRouteTableId(): string;
    get defaultSecurityGroupId(): string;
    get dhcpOptionsId(): string;
    private _enableClassiclink?;
    get enableClassiclink(): boolean | undefined;
    set enableClassiclink(value: boolean | undefined);
    private _enableClassiclinkDnsSupport?;
    get enableClassiclinkDnsSupport(): boolean | undefined;
    set enableClassiclinkDnsSupport(value: boolean | undefined);
    private _enableDnsHostnames?;
    get enableDnsHostnames(): boolean | undefined;
    set enableDnsHostnames(value: boolean | undefined);
    private _enableDnsSupport?;
    get enableDnsSupport(): boolean | undefined;
    set enableDnsSupport(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get instanceTenancy(): string;
    get ipv6AssociationId(): string;
    get ipv6CidrBlock(): string;
    get mainRouteTableId(): string;
    get ownerId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
