"use strict";
// https://www.terraform.io/docs/providers/aws/r/default_vpc.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultVpc = void 0;
const cdktf_1 = require("cdktf");
// Resource
class DefaultVpc extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'aws_default_vpc',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._enableClassiclink = config.enableClassiclink;
        this._enableClassiclinkDnsSupport = config.enableClassiclinkDnsSupport;
        this._enableDnsHostnames = config.enableDnsHostnames;
        this._enableDnsSupport = config.enableDnsSupport;
        this._tags = config.tags;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    // assign_generated_ipv6_cidr_block - computed: true, optional: false, required: true
    get assignGeneratedIpv6CidrBlock() {
        return this.getBooleanAttribute('assign_generated_ipv6_cidr_block');
    }
    // cidr_block - computed: true, optional: false, required: true
    get cidrBlock() {
        return this.getStringAttribute('cidr_block');
    }
    // default_network_acl_id - computed: true, optional: false, required: true
    get defaultNetworkAclId() {
        return this.getStringAttribute('default_network_acl_id');
    }
    // default_route_table_id - computed: true, optional: false, required: true
    get defaultRouteTableId() {
        return this.getStringAttribute('default_route_table_id');
    }
    // default_security_group_id - computed: true, optional: false, required: true
    get defaultSecurityGroupId() {
        return this.getStringAttribute('default_security_group_id');
    }
    // dhcp_options_id - computed: true, optional: false, required: true
    get dhcpOptionsId() {
        return this.getStringAttribute('dhcp_options_id');
    }
    get enableClassiclink() {
        var _a;
        return (_a = this._enableClassiclink) !== null && _a !== void 0 ? _a : this.getBooleanAttribute('enable_classiclink');
    }
    set enableClassiclink(value) {
        this._enableClassiclink = value;
    }
    get enableClassiclinkDnsSupport() {
        var _a;
        return (_a = this._enableClassiclinkDnsSupport) !== null && _a !== void 0 ? _a : this.getBooleanAttribute('enable_classiclink_dns_support');
    }
    set enableClassiclinkDnsSupport(value) {
        this._enableClassiclinkDnsSupport = value;
    }
    get enableDnsHostnames() {
        var _a;
        return (_a = this._enableDnsHostnames) !== null && _a !== void 0 ? _a : this.getBooleanAttribute('enable_dns_hostnames');
    }
    set enableDnsHostnames(value) {
        this._enableDnsHostnames = value;
    }
    get enableDnsSupport() {
        return this._enableDnsSupport;
    }
    set enableDnsSupport(value) {
        this._enableDnsSupport = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    // instance_tenancy - computed: true, optional: false, required: true
    get instanceTenancy() {
        return this.getStringAttribute('instance_tenancy');
    }
    // ipv6_association_id - computed: true, optional: false, required: true
    get ipv6AssociationId() {
        return this.getStringAttribute('ipv6_association_id');
    }
    // ipv6_cidr_block - computed: true, optional: false, required: true
    get ipv6CidrBlock() {
        return this.getStringAttribute('ipv6_cidr_block');
    }
    // main_route_table_id - computed: true, optional: false, required: true
    get mainRouteTableId() {
        return this.getStringAttribute('main_route_table_id');
    }
    // owner_id - computed: true, optional: false, required: true
    get ownerId() {
        return this.getStringAttribute('owner_id');
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            enable_classiclink: this._enableClassiclink,
            enable_classiclink_dns_support: this._enableClassiclinkDnsSupport,
            enable_dns_hostnames: this._enableDnsHostnames,
            enable_dns_support: this._enableDnsSupport,
            tags: this._tags,
        };
    }
}
exports.DefaultVpc = DefaultVpc;
//# sourceMappingURL=data:application/json;base64,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