import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DirectoryServiceDirectoryConfig extends TerraformMetaArguments {
    readonly alias?: string;
    readonly description?: string;
    readonly edition?: string;
    readonly enableSso?: boolean;
    readonly name: string;
    readonly password: string;
    readonly shortName?: string;
    readonly size?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly type?: string;
    /** connect_settings block */
    readonly connectSettings?: DirectoryServiceDirectoryConnectSettings[];
    /** vpc_settings block */
    readonly vpcSettings?: DirectoryServiceDirectoryVpcSettings[];
}
export interface DirectoryServiceDirectoryConnectSettings {
    readonly customerDnsIps: string[];
    readonly customerUsername: string;
    readonly subnetIds: string[];
    readonly vpcId: string;
}
export interface DirectoryServiceDirectoryVpcSettings {
    readonly subnetIds: string[];
    readonly vpcId: string;
}
export declare class DirectoryServiceDirectory extends TerraformResource {
    constructor(scope: Construct, id: string, config: DirectoryServiceDirectoryConfig);
    get accessUrl(): string;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    get dnsIpAddresses(): string[];
    private _edition?;
    get edition(): string | undefined;
    set edition(value: string | undefined);
    private _enableSso?;
    get enableSso(): boolean | undefined;
    set enableSso(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _password;
    get password(): string;
    set password(value: string);
    get securityGroupId(): string;
    private _shortName?;
    get shortName(): string | undefined;
    set shortName(value: string | undefined);
    private _size?;
    get size(): string | undefined;
    set size(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _type?;
    get type(): string | undefined;
    set type(value: string | undefined);
    private _connectSettings?;
    get connectSettings(): DirectoryServiceDirectoryConnectSettings[] | undefined;
    set connectSettings(value: DirectoryServiceDirectoryConnectSettings[] | undefined);
    private _vpcSettings?;
    get vpcSettings(): DirectoryServiceDirectoryVpcSettings[] | undefined;
    set vpcSettings(value: DirectoryServiceDirectoryVpcSettings[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
