import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DlmLifecyclePolicyConfig extends TerraformMetaArguments {
    readonly description: string;
    readonly executionRoleArn: string;
    readonly state?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** policy_details block */
    readonly policyDetails: DlmLifecyclePolicyPolicyDetails[];
}
export interface DlmLifecyclePolicyPolicyDetailsScheduleCreateRule {
    readonly interval: number;
    readonly intervalUnit?: string;
    readonly times?: string[];
}
export interface DlmLifecyclePolicyPolicyDetailsScheduleRetainRule {
    readonly count: number;
}
export interface DlmLifecyclePolicyPolicyDetailsSchedule {
    readonly copyTags?: boolean;
    readonly name: string;
    readonly tagsToAdd?: {
        [key: string]: string;
    };
    /** create_rule block */
    readonly createRule: DlmLifecyclePolicyPolicyDetailsScheduleCreateRule[];
    /** retain_rule block */
    readonly retainRule: DlmLifecyclePolicyPolicyDetailsScheduleRetainRule[];
}
export interface DlmLifecyclePolicyPolicyDetails {
    readonly resourceTypes: string[];
    readonly targetTags: {
        [key: string]: string;
    };
    /** schedule block */
    readonly schedule: DlmLifecyclePolicyPolicyDetailsSchedule[];
}
export declare class DlmLifecyclePolicy extends TerraformResource {
    constructor(scope: Construct, id: string, config: DlmLifecyclePolicyConfig);
    get arn(): string;
    private _description;
    get description(): string;
    set description(value: string);
    private _executionRoleArn;
    get executionRoleArn(): string;
    set executionRoleArn(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _state?;
    get state(): string | undefined;
    set state(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _policyDetails;
    get policyDetails(): DlmLifecyclePolicyPolicyDetails[];
    set policyDetails(value: DlmLifecyclePolicyPolicyDetails[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
