import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DmsEndpointConfig extends TerraformMetaArguments {
    readonly certificateArn?: string;
    readonly databaseName?: string;
    readonly endpointId: string;
    readonly endpointType: string;
    readonly engineName: string;
    readonly extraConnectionAttributes?: string;
    readonly kmsKeyArn?: string;
    readonly password?: string;
    readonly port?: number;
    readonly serverName?: string;
    readonly serviceAccessRole?: string;
    readonly sslMode?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly username?: string;
    /** elasticsearch_settings block */
    readonly elasticsearchSettings?: DmsEndpointElasticsearchSettings[];
    /** kafka_settings block */
    readonly kafkaSettings?: DmsEndpointKafkaSettings[];
    /** kinesis_settings block */
    readonly kinesisSettings?: DmsEndpointKinesisSettings[];
    /** mongodb_settings block */
    readonly mongodbSettings?: DmsEndpointMongodbSettings[];
    /** s3_settings block */
    readonly s3Settings?: DmsEndpointS3Settings[];
}
export interface DmsEndpointElasticsearchSettings {
    readonly endpointUri: string;
    readonly errorRetryDuration?: number;
    readonly fullLoadErrorPercentage?: number;
    readonly serviceAccessRoleArn: string;
}
export interface DmsEndpointKafkaSettings {
    readonly broker: string;
    readonly topic?: string;
}
export interface DmsEndpointKinesisSettings {
    readonly messageFormat?: string;
    readonly serviceAccessRoleArn?: string;
    readonly streamArn?: string;
}
export interface DmsEndpointMongodbSettings {
    readonly authMechanism?: string;
    readonly authSource?: string;
    readonly authType?: string;
    readonly docsToInvestigate?: string;
    readonly extractDocId?: string;
    readonly nestingLevel?: string;
}
export interface DmsEndpointS3Settings {
    readonly bucketFolder?: string;
    readonly bucketName?: string;
    readonly compressionType?: string;
    readonly csvDelimiter?: string;
    readonly csvRowDelimiter?: string;
    readonly externalTableDefinition?: string;
    readonly serviceAccessRoleArn?: string;
}
export declare class DmsEndpoint extends TerraformResource {
    constructor(scope: Construct, id: string, config: DmsEndpointConfig);
    private _certificateArn?;
    get certificateArn(): string | undefined;
    set certificateArn(value: string | undefined);
    private _databaseName?;
    get databaseName(): string | undefined;
    set databaseName(value: string | undefined);
    get endpointArn(): string;
    private _endpointId;
    get endpointId(): string;
    set endpointId(value: string);
    private _endpointType;
    get endpointType(): string;
    set endpointType(value: string);
    private _engineName;
    get engineName(): string;
    set engineName(value: string);
    private _extraConnectionAttributes?;
    get extraConnectionAttributes(): string | undefined;
    set extraConnectionAttributes(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _kmsKeyArn?;
    get kmsKeyArn(): string | undefined;
    set kmsKeyArn(value: string | undefined);
    private _password?;
    get password(): string | undefined;
    set password(value: string | undefined);
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    private _serverName?;
    get serverName(): string | undefined;
    set serverName(value: string | undefined);
    private _serviceAccessRole?;
    get serviceAccessRole(): string | undefined;
    set serviceAccessRole(value: string | undefined);
    private _sslMode?;
    get sslMode(): string | undefined;
    set sslMode(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _username?;
    get username(): string | undefined;
    set username(value: string | undefined);
    private _elasticsearchSettings?;
    get elasticsearchSettings(): DmsEndpointElasticsearchSettings[] | undefined;
    set elasticsearchSettings(value: DmsEndpointElasticsearchSettings[] | undefined);
    private _kafkaSettings?;
    get kafkaSettings(): DmsEndpointKafkaSettings[] | undefined;
    set kafkaSettings(value: DmsEndpointKafkaSettings[] | undefined);
    private _kinesisSettings?;
    get kinesisSettings(): DmsEndpointKinesisSettings[] | undefined;
    set kinesisSettings(value: DmsEndpointKinesisSettings[] | undefined);
    private _mongodbSettings?;
    get mongodbSettings(): DmsEndpointMongodbSettings[] | undefined;
    set mongodbSettings(value: DmsEndpointMongodbSettings[] | undefined);
    private _s3Settings?;
    get s3Settings(): DmsEndpointS3Settings[] | undefined;
    set s3Settings(value: DmsEndpointS3Settings[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
