import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DmsEventSubscriptionConfig extends TerraformMetaArguments {
    readonly enabled?: boolean;
    readonly eventCategories: string[];
    readonly name: string;
    readonly snsTopicArn: string;
    readonly sourceIds?: string[];
    readonly sourceType?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** timeouts block */
    readonly timeouts?: DmsEventSubscriptionTimeouts;
}
export interface DmsEventSubscriptionTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class DmsEventSubscription extends TerraformResource {
    constructor(scope: Construct, id: string, config: DmsEventSubscriptionConfig);
    get arn(): string;
    private _enabled?;
    get enabled(): boolean | undefined;
    set enabled(value: boolean | undefined);
    private _eventCategories;
    get eventCategories(): string[];
    set eventCategories(value: string[]);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _snsTopicArn;
    get snsTopicArn(): string;
    set snsTopicArn(value: string);
    private _sourceIds?;
    get sourceIds(): string[] | undefined;
    set sourceIds(value: string[] | undefined);
    private _sourceType?;
    get sourceType(): string | undefined;
    set sourceType(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _timeouts?;
    get timeouts(): DmsEventSubscriptionTimeouts | undefined;
    set timeouts(value: DmsEventSubscriptionTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
