import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DmsReplicationInstanceConfig extends TerraformMetaArguments {
    readonly allocatedStorage?: number;
    readonly applyImmediately?: boolean;
    readonly autoMinorVersionUpgrade?: boolean;
    readonly availabilityZone?: string;
    readonly engineVersion?: string;
    readonly kmsKeyArn?: string;
    readonly multiAz?: boolean;
    readonly preferredMaintenanceWindow?: string;
    readonly publiclyAccessible?: boolean;
    readonly replicationInstanceClass: string;
    readonly replicationInstanceId: string;
    readonly replicationSubnetGroupId?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly vpcSecurityGroupIds?: string[];
    /** timeouts block */
    readonly timeouts?: DmsReplicationInstanceTimeouts;
}
export interface DmsReplicationInstanceTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class DmsReplicationInstance extends TerraformResource {
    constructor(scope: Construct, id: string, config: DmsReplicationInstanceConfig);
    private _allocatedStorage?;
    get allocatedStorage(): number | undefined;
    set allocatedStorage(value: number | undefined);
    private _applyImmediately?;
    get applyImmediately(): boolean | undefined;
    set applyImmediately(value: boolean | undefined);
    private _autoMinorVersionUpgrade?;
    get autoMinorVersionUpgrade(): boolean | undefined;
    set autoMinorVersionUpgrade(value: boolean | undefined);
    private _availabilityZone?;
    get availabilityZone(): string | undefined;
    set availabilityZone(value: string | undefined);
    private _engineVersion?;
    get engineVersion(): string | undefined;
    set engineVersion(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _kmsKeyArn?;
    get kmsKeyArn(): string | undefined;
    set kmsKeyArn(value: string | undefined);
    private _multiAz?;
    get multiAz(): boolean | undefined;
    set multiAz(value: boolean | undefined);
    private _preferredMaintenanceWindow?;
    get preferredMaintenanceWindow(): string | undefined;
    set preferredMaintenanceWindow(value: string | undefined);
    private _publiclyAccessible?;
    get publiclyAccessible(): boolean | undefined;
    set publiclyAccessible(value: boolean | undefined);
    get replicationInstanceArn(): string;
    private _replicationInstanceClass;
    get replicationInstanceClass(): string;
    set replicationInstanceClass(value: string);
    private _replicationInstanceId;
    get replicationInstanceId(): string;
    set replicationInstanceId(value: string);
    get replicationInstancePrivateIps(): string[];
    get replicationInstancePublicIps(): string[];
    private _replicationSubnetGroupId?;
    get replicationSubnetGroupId(): string | undefined;
    set replicationSubnetGroupId(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _vpcSecurityGroupIds?;
    get vpcSecurityGroupIds(): string[] | undefined;
    set vpcSecurityGroupIds(value: string[] | undefined);
    private _timeouts?;
    get timeouts(): DmsReplicationInstanceTimeouts | undefined;
    set timeouts(value: DmsReplicationInstanceTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
