import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DmsReplicationSubnetGroupConfig extends TerraformMetaArguments {
    readonly replicationSubnetGroupDescription: string;
    readonly replicationSubnetGroupId: string;
    readonly subnetIds: string[];
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DmsReplicationSubnetGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config: DmsReplicationSubnetGroupConfig);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get replicationSubnetGroupArn(): string;
    private _replicationSubnetGroupDescription;
    get replicationSubnetGroupDescription(): string;
    set replicationSubnetGroupDescription(value: string);
    private _replicationSubnetGroupId;
    get replicationSubnetGroupId(): string;
    set replicationSubnetGroupId(value: string);
    private _subnetIds;
    get subnetIds(): string[];
    set subnetIds(value: string[]);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get vpcId(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
