import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DmsReplicationTaskConfig extends TerraformMetaArguments {
    readonly cdcStartTime?: string;
    readonly migrationType: string;
    readonly replicationInstanceArn: string;
    readonly replicationTaskId: string;
    readonly replicationTaskSettings?: string;
    readonly sourceEndpointArn: string;
    readonly tableMappings: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly targetEndpointArn: string;
}
export declare class DmsReplicationTask extends TerraformResource {
    constructor(scope: Construct, id: string, config: DmsReplicationTaskConfig);
    private _cdcStartTime?;
    get cdcStartTime(): string | undefined;
    set cdcStartTime(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _migrationType;
    get migrationType(): string;
    set migrationType(value: string);
    private _replicationInstanceArn;
    get replicationInstanceArn(): string;
    set replicationInstanceArn(value: string);
    get replicationTaskArn(): string;
    private _replicationTaskId;
    get replicationTaskId(): string;
    set replicationTaskId(value: string);
    private _replicationTaskSettings?;
    get replicationTaskSettings(): string | undefined;
    set replicationTaskSettings(value: string | undefined);
    private _sourceEndpointArn;
    get sourceEndpointArn(): string;
    set sourceEndpointArn(value: string);
    private _tableMappings;
    get tableMappings(): string;
    set tableMappings(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _targetEndpointArn;
    get targetEndpointArn(): string;
    set targetEndpointArn(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
