"use strict";
// https://www.terraform.io/docs/providers/aws/r/dms_replication_task.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.DmsReplicationTask = void 0;
const cdktf_1 = require("cdktf");
// Resource
class DmsReplicationTask extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_dms_replication_task',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._cdcStartTime = config.cdcStartTime;
        this._migrationType = config.migrationType;
        this._replicationInstanceArn = config.replicationInstanceArn;
        this._replicationTaskId = config.replicationTaskId;
        this._replicationTaskSettings = config.replicationTaskSettings;
        this._sourceEndpointArn = config.sourceEndpointArn;
        this._tableMappings = config.tableMappings;
        this._tags = config.tags;
        this._targetEndpointArn = config.targetEndpointArn;
    }
    get cdcStartTime() {
        return this._cdcStartTime;
    }
    set cdcStartTime(value) {
        this._cdcStartTime = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get migrationType() {
        return this._migrationType;
    }
    set migrationType(value) {
        this._migrationType = value;
    }
    get replicationInstanceArn() {
        return this._replicationInstanceArn;
    }
    set replicationInstanceArn(value) {
        this._replicationInstanceArn = value;
    }
    // replication_task_arn - computed: true, optional: false, required: true
    get replicationTaskArn() {
        return this.getStringAttribute('replication_task_arn');
    }
    get replicationTaskId() {
        return this._replicationTaskId;
    }
    set replicationTaskId(value) {
        this._replicationTaskId = value;
    }
    get replicationTaskSettings() {
        return this._replicationTaskSettings;
    }
    set replicationTaskSettings(value) {
        this._replicationTaskSettings = value;
    }
    get sourceEndpointArn() {
        return this._sourceEndpointArn;
    }
    set sourceEndpointArn(value) {
        this._sourceEndpointArn = value;
    }
    get tableMappings() {
        return this._tableMappings;
    }
    set tableMappings(value) {
        this._tableMappings = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get targetEndpointArn() {
        return this._targetEndpointArn;
    }
    set targetEndpointArn(value) {
        this._targetEndpointArn = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            cdc_start_time: this._cdcStartTime,
            migration_type: this._migrationType,
            replication_instance_arn: this._replicationInstanceArn,
            replication_task_id: this._replicationTaskId,
            replication_task_settings: this._replicationTaskSettings,
            source_endpoint_arn: this._sourceEndpointArn,
            table_mappings: this._tableMappings,
            tags: this._tags,
            target_endpoint_arn: this._targetEndpointArn,
        };
    }
}
exports.DmsReplicationTask = DmsReplicationTask;
//# sourceMappingURL=data:application/json;base64,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