import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DocdbClusterInstanceConfig extends TerraformMetaArguments {
    readonly applyImmediately?: boolean;
    readonly autoMinorVersionUpgrade?: boolean;
    readonly availabilityZone?: string;
    readonly caCertIdentifier?: string;
    readonly clusterIdentifier: string;
    readonly engine?: string;
    readonly identifier?: string;
    readonly identifierPrefix?: string;
    readonly instanceClass: string;
    readonly preferredMaintenanceWindow?: string;
    readonly promotionTier?: number;
    readonly tags?: {
        [key: string]: string;
    };
    /** timeouts block */
    readonly timeouts?: DocdbClusterInstanceTimeouts;
}
export interface DocdbClusterInstanceTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class DocdbClusterInstance extends TerraformResource {
    constructor(scope: Construct, id: string, config: DocdbClusterInstanceConfig);
    private _applyImmediately?;
    get applyImmediately(): boolean | undefined;
    set applyImmediately(value: boolean | undefined);
    get arn(): string;
    private _autoMinorVersionUpgrade?;
    get autoMinorVersionUpgrade(): boolean | undefined;
    set autoMinorVersionUpgrade(value: boolean | undefined);
    private _availabilityZone?;
    get availabilityZone(): string | undefined;
    set availabilityZone(value: string | undefined);
    private _caCertIdentifier?;
    get caCertIdentifier(): string | undefined;
    set caCertIdentifier(value: string | undefined);
    private _clusterIdentifier;
    get clusterIdentifier(): string;
    set clusterIdentifier(value: string);
    get dbSubnetGroupName(): string;
    get dbiResourceId(): string;
    get endpoint(): string;
    private _engine?;
    get engine(): string | undefined;
    set engine(value: string | undefined);
    get engineVersion(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _identifier?;
    get identifier(): string | undefined;
    set identifier(value: string | undefined);
    private _identifierPrefix?;
    get identifierPrefix(): string | undefined;
    set identifierPrefix(value: string | undefined);
    private _instanceClass;
    get instanceClass(): string;
    set instanceClass(value: string);
    get kmsKeyId(): string;
    get port(): number;
    get preferredBackupWindow(): string;
    private _preferredMaintenanceWindow?;
    get preferredMaintenanceWindow(): string | undefined;
    set preferredMaintenanceWindow(value: string | undefined);
    private _promotionTier?;
    get promotionTier(): number | undefined;
    set promotionTier(value: number | undefined);
    get publiclyAccessible(): boolean;
    get storageEncrypted(): boolean;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get writer(): boolean;
    private _timeouts?;
    get timeouts(): DocdbClusterInstanceTimeouts | undefined;
    set timeouts(value: DocdbClusterInstanceTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
