import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DocdbClusterSnapshotConfig extends TerraformMetaArguments {
    readonly dbClusterIdentifier: string;
    readonly dbClusterSnapshotIdentifier: string;
    /** timeouts block */
    readonly timeouts?: DocdbClusterSnapshotTimeouts;
}
export interface DocdbClusterSnapshotTimeouts {
    readonly create?: string;
}
export declare class DocdbClusterSnapshot extends TerraformResource {
    constructor(scope: Construct, id: string, config: DocdbClusterSnapshotConfig);
    get availabilityZones(): string[];
    private _dbClusterIdentifier;
    get dbClusterIdentifier(): string;
    set dbClusterIdentifier(value: string);
    get dbClusterSnapshotArn(): string;
    private _dbClusterSnapshotIdentifier;
    get dbClusterSnapshotIdentifier(): string;
    set dbClusterSnapshotIdentifier(value: string);
    get engine(): string;
    get engineVersion(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get kmsKeyId(): string;
    get port(): number;
    get snapshotType(): string;
    get sourceDbClusterSnapshotArn(): string;
    get status(): string;
    get storageEncrypted(): boolean;
    get vpcId(): string;
    private _timeouts?;
    get timeouts(): DocdbClusterSnapshotTimeouts | undefined;
    set timeouts(value: DocdbClusterSnapshotTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
