import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DocdbClusterConfig extends TerraformMetaArguments {
    readonly applyImmediately?: boolean;
    readonly availabilityZones?: string[];
    readonly backupRetentionPeriod?: number;
    readonly clusterIdentifier?: string;
    readonly clusterIdentifierPrefix?: string;
    readonly clusterMembers?: string[];
    readonly dbClusterParameterGroupName?: string;
    readonly dbSubnetGroupName?: string;
    readonly deletionProtection?: boolean;
    readonly enabledCloudwatchLogsExports?: string[];
    readonly engine?: string;
    readonly engineVersion?: string;
    readonly finalSnapshotIdentifier?: string;
    readonly kmsKeyId?: string;
    readonly masterPassword?: string;
    readonly masterUsername?: string;
    readonly port?: number;
    readonly preferredBackupWindow?: string;
    readonly preferredMaintenanceWindow?: string;
    readonly skipFinalSnapshot?: boolean;
    readonly snapshotIdentifier?: string;
    readonly storageEncrypted?: boolean;
    readonly tags?: {
        [key: string]: string;
    };
    readonly vpcSecurityGroupIds?: string[];
    /** timeouts block */
    readonly timeouts?: DocdbClusterTimeouts;
}
export interface DocdbClusterTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class DocdbCluster extends TerraformResource {
    constructor(scope: Construct, id: string, config?: DocdbClusterConfig);
    private _applyImmediately?;
    get applyImmediately(): boolean | undefined;
    set applyImmediately(value: boolean | undefined);
    get arn(): string;
    private _availabilityZones?;
    get availabilityZones(): string[] | undefined;
    set availabilityZones(value: string[] | undefined);
    private _backupRetentionPeriod?;
    get backupRetentionPeriod(): number | undefined;
    set backupRetentionPeriod(value: number | undefined);
    private _clusterIdentifier?;
    get clusterIdentifier(): string | undefined;
    set clusterIdentifier(value: string | undefined);
    private _clusterIdentifierPrefix?;
    get clusterIdentifierPrefix(): string | undefined;
    set clusterIdentifierPrefix(value: string | undefined);
    private _clusterMembers?;
    get clusterMembers(): string[] | undefined;
    set clusterMembers(value: string[] | undefined);
    get clusterResourceId(): string;
    private _dbClusterParameterGroupName?;
    get dbClusterParameterGroupName(): string | undefined;
    set dbClusterParameterGroupName(value: string | undefined);
    private _dbSubnetGroupName?;
    get dbSubnetGroupName(): string | undefined;
    set dbSubnetGroupName(value: string | undefined);
    private _deletionProtection?;
    get deletionProtection(): boolean | undefined;
    set deletionProtection(value: boolean | undefined);
    private _enabledCloudwatchLogsExports?;
    get enabledCloudwatchLogsExports(): string[] | undefined;
    set enabledCloudwatchLogsExports(value: string[] | undefined);
    get endpoint(): string;
    private _engine?;
    get engine(): string | undefined;
    set engine(value: string | undefined);
    private _engineVersion?;
    get engineVersion(): string | undefined;
    set engineVersion(value: string | undefined);
    private _finalSnapshotIdentifier?;
    get finalSnapshotIdentifier(): string | undefined;
    set finalSnapshotIdentifier(value: string | undefined);
    get hostedZoneId(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _kmsKeyId?;
    get kmsKeyId(): string | undefined;
    set kmsKeyId(value: string | undefined);
    private _masterPassword?;
    get masterPassword(): string | undefined;
    set masterPassword(value: string | undefined);
    private _masterUsername?;
    get masterUsername(): string | undefined;
    set masterUsername(value: string | undefined);
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    private _preferredBackupWindow?;
    get preferredBackupWindow(): string | undefined;
    set preferredBackupWindow(value: string | undefined);
    private _preferredMaintenanceWindow?;
    get preferredMaintenanceWindow(): string | undefined;
    set preferredMaintenanceWindow(value: string | undefined);
    get readerEndpoint(): string;
    private _skipFinalSnapshot?;
    get skipFinalSnapshot(): boolean | undefined;
    set skipFinalSnapshot(value: boolean | undefined);
    private _snapshotIdentifier?;
    get snapshotIdentifier(): string | undefined;
    set snapshotIdentifier(value: string | undefined);
    private _storageEncrypted?;
    get storageEncrypted(): boolean | undefined;
    set storageEncrypted(value: boolean | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _vpcSecurityGroupIds?;
    get vpcSecurityGroupIds(): string[] | undefined;
    set vpcSecurityGroupIds(value: string[] | undefined);
    private _timeouts?;
    get timeouts(): DocdbClusterTimeouts | undefined;
    set timeouts(value: DocdbClusterTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
