import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DxBgpPeerConfig extends TerraformMetaArguments {
    readonly addressFamily: string;
    readonly amazonAddress?: string;
    readonly bgpAsn: number;
    readonly bgpAuthKey?: string;
    readonly customerAddress?: string;
    readonly virtualInterfaceId: string;
    /** timeouts block */
    readonly timeouts?: DxBgpPeerTimeouts;
}
export interface DxBgpPeerTimeouts {
    readonly create?: string;
    readonly delete?: string;
}
export declare class DxBgpPeer extends TerraformResource {
    constructor(scope: Construct, id: string, config: DxBgpPeerConfig);
    private _addressFamily;
    get addressFamily(): string;
    set addressFamily(value: string);
    private _amazonAddress?;
    get amazonAddress(): string | undefined;
    set amazonAddress(value: string | undefined);
    get awsDevice(): string;
    private _bgpAsn;
    get bgpAsn(): number;
    set bgpAsn(value: number);
    private _bgpAuthKey?;
    get bgpAuthKey(): string | undefined;
    set bgpAuthKey(value: string | undefined);
    get bgpPeerId(): string;
    get bgpStatus(): string;
    private _customerAddress?;
    get customerAddress(): string | undefined;
    set customerAddress(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _virtualInterfaceId;
    get virtualInterfaceId(): string;
    set virtualInterfaceId(value: string);
    private _timeouts?;
    get timeouts(): DxBgpPeerTimeouts | undefined;
    set timeouts(value: DxBgpPeerTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
