import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DxConnectionConfig extends TerraformMetaArguments {
    readonly bandwidth: string;
    readonly location: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DxConnection extends TerraformResource {
    constructor(scope: Construct, id: string, config: DxConnectionConfig);
    get arn(): string;
    get awsDevice(): string;
    private _bandwidth;
    get bandwidth(): string;
    set bandwidth(value: string);
    get hasLogicalRedundancy(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get jumboFrameCapable(): boolean;
    private _location;
    get location(): string;
    set location(value: string);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
