"use strict";
// https://www.terraform.io/docs/providers/aws/r/dx_gateway_association_proposal.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.DxGatewayAssociationProposal = void 0;
const cdktf_1 = require("cdktf");
// Resource
class DxGatewayAssociationProposal extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_dx_gateway_association_proposal',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._allowedPrefixes = config.allowedPrefixes;
        this._associatedGatewayId = config.associatedGatewayId;
        this._dxGatewayId = config.dxGatewayId;
        this._dxGatewayOwnerAccountId = config.dxGatewayOwnerAccountId;
        this._vpnGatewayId = config.vpnGatewayId;
    }
    get allowedPrefixes() {
        var _a;
        return (_a = this._allowedPrefixes) !== null && _a !== void 0 ? _a : this.getListAttribute('allowed_prefixes');
    }
    set allowedPrefixes(value) {
        this._allowedPrefixes = value;
    }
    get associatedGatewayId() {
        return this._associatedGatewayId;
    }
    set associatedGatewayId(value) {
        this._associatedGatewayId = value;
    }
    // associated_gateway_owner_account_id - computed: true, optional: false, required: true
    get associatedGatewayOwnerAccountId() {
        return this.getStringAttribute('associated_gateway_owner_account_id');
    }
    // associated_gateway_type - computed: true, optional: false, required: true
    get associatedGatewayType() {
        return this.getStringAttribute('associated_gateway_type');
    }
    get dxGatewayId() {
        return this._dxGatewayId;
    }
    set dxGatewayId(value) {
        this._dxGatewayId = value;
    }
    get dxGatewayOwnerAccountId() {
        return this._dxGatewayOwnerAccountId;
    }
    set dxGatewayOwnerAccountId(value) {
        this._dxGatewayOwnerAccountId = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get vpnGatewayId() {
        return this._vpnGatewayId;
    }
    set vpnGatewayId(value) {
        this._vpnGatewayId = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allowed_prefixes: this._allowedPrefixes,
            associated_gateway_id: this._associatedGatewayId,
            dx_gateway_id: this._dxGatewayId,
            dx_gateway_owner_account_id: this._dxGatewayOwnerAccountId,
            vpn_gateway_id: this._vpnGatewayId,
        };
    }
}
exports.DxGatewayAssociationProposal = DxGatewayAssociationProposal;
//# sourceMappingURL=data:application/json;base64,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