import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DxGatewayAssociationConfig extends TerraformMetaArguments {
    readonly allowedPrefixes?: string[];
    readonly associatedGatewayId?: string;
    readonly associatedGatewayOwnerAccountId?: string;
    readonly dxGatewayId: string;
    readonly proposalId?: string;
    readonly vpnGatewayId?: string;
    /** timeouts block */
    readonly timeouts?: DxGatewayAssociationTimeouts;
}
export interface DxGatewayAssociationTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class DxGatewayAssociation extends TerraformResource {
    constructor(scope: Construct, id: string, config: DxGatewayAssociationConfig);
    private _allowedPrefixes?;
    get allowedPrefixes(): string[] | undefined;
    set allowedPrefixes(value: string[] | undefined);
    private _associatedGatewayId?;
    get associatedGatewayId(): string | undefined;
    set associatedGatewayId(value: string | undefined);
    private _associatedGatewayOwnerAccountId?;
    get associatedGatewayOwnerAccountId(): string | undefined;
    set associatedGatewayOwnerAccountId(value: string | undefined);
    get associatedGatewayType(): string;
    get dxGatewayAssociationId(): string;
    private _dxGatewayId;
    get dxGatewayId(): string;
    set dxGatewayId(value: string);
    get dxGatewayOwnerAccountId(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _proposalId?;
    get proposalId(): string | undefined;
    set proposalId(value: string | undefined);
    private _vpnGatewayId?;
    get vpnGatewayId(): string | undefined;
    set vpnGatewayId(value: string | undefined);
    private _timeouts?;
    get timeouts(): DxGatewayAssociationTimeouts | undefined;
    set timeouts(value: DxGatewayAssociationTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
