import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DxGatewayConfig extends TerraformMetaArguments {
    readonly amazonSideAsn: string;
    readonly name: string;
    /** timeouts block */
    readonly timeouts?: DxGatewayTimeouts;
}
export interface DxGatewayTimeouts {
    readonly create?: string;
    readonly delete?: string;
}
export declare class DxGateway extends TerraformResource {
    constructor(scope: Construct, id: string, config: DxGatewayConfig);
    private _amazonSideAsn;
    get amazonSideAsn(): string;
    set amazonSideAsn(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    get ownerAccountId(): string;
    private _timeouts?;
    get timeouts(): DxGatewayTimeouts | undefined;
    set timeouts(value: DxGatewayTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
