import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DxHostedPrivateVirtualInterfaceAccepterConfig extends TerraformMetaArguments {
    readonly dxGatewayId?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly virtualInterfaceId: string;
    readonly vpnGatewayId?: string;
    /** timeouts block */
    readonly timeouts?: DxHostedPrivateVirtualInterfaceAccepterTimeouts;
}
export interface DxHostedPrivateVirtualInterfaceAccepterTimeouts {
    readonly create?: string;
    readonly delete?: string;
}
export declare class DxHostedPrivateVirtualInterfaceAccepter extends TerraformResource {
    constructor(scope: Construct, id: string, config: DxHostedPrivateVirtualInterfaceAccepterConfig);
    get arn(): string;
    private _dxGatewayId?;
    get dxGatewayId(): string | undefined;
    set dxGatewayId(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _virtualInterfaceId;
    get virtualInterfaceId(): string;
    set virtualInterfaceId(value: string);
    private _vpnGatewayId?;
    get vpnGatewayId(): string | undefined;
    set vpnGatewayId(value: string | undefined);
    private _timeouts?;
    get timeouts(): DxHostedPrivateVirtualInterfaceAccepterTimeouts | undefined;
    set timeouts(value: DxHostedPrivateVirtualInterfaceAccepterTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
