import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DxHostedTransitVirtualInterfaceAccepterConfig extends TerraformMetaArguments {
    readonly dxGatewayId: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly virtualInterfaceId: string;
    /** timeouts block */
    readonly timeouts?: DxHostedTransitVirtualInterfaceAccepterTimeouts;
}
export interface DxHostedTransitVirtualInterfaceAccepterTimeouts {
    readonly create?: string;
    readonly delete?: string;
}
export declare class DxHostedTransitVirtualInterfaceAccepter extends TerraformResource {
    constructor(scope: Construct, id: string, config: DxHostedTransitVirtualInterfaceAccepterConfig);
    get arn(): string;
    private _dxGatewayId;
    get dxGatewayId(): string;
    set dxGatewayId(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _virtualInterfaceId;
    get virtualInterfaceId(): string;
    set virtualInterfaceId(value: string);
    private _timeouts?;
    get timeouts(): DxHostedTransitVirtualInterfaceAccepterTimeouts | undefined;
    set timeouts(value: DxHostedTransitVirtualInterfaceAccepterTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
