import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DxLagConfig extends TerraformMetaArguments {
    readonly connectionsBandwidth: string;
    readonly forceDestroy?: boolean;
    readonly location: string;
    readonly name: string;
    readonly numberOfConnections?: number;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DxLag extends TerraformResource {
    constructor(scope: Construct, id: string, config: DxLagConfig);
    get arn(): string;
    private _connectionsBandwidth;
    get connectionsBandwidth(): string;
    set connectionsBandwidth(value: string);
    private _forceDestroy?;
    get forceDestroy(): boolean | undefined;
    set forceDestroy(value: boolean | undefined);
    get hasLogicalRedundancy(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get jumboFrameCapable(): boolean;
    private _location;
    get location(): string;
    set location(value: string);
    private _name;
    get name(): string;
    set name(value: string);
    private _numberOfConnections?;
    get numberOfConnections(): number | undefined;
    set numberOfConnections(value: number | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
