"use strict";
// https://www.terraform.io/docs/providers/aws/r/dx_private_virtual_interface.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.DxPrivateVirtualInterface = void 0;
const cdktf_1 = require("cdktf");
// Resource
class DxPrivateVirtualInterface extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_dx_private_virtual_interface',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._addressFamily = config.addressFamily;
        this._amazonAddress = config.amazonAddress;
        this._bgpAsn = config.bgpAsn;
        this._bgpAuthKey = config.bgpAuthKey;
        this._connectionId = config.connectionId;
        this._customerAddress = config.customerAddress;
        this._dxGatewayId = config.dxGatewayId;
        this._mtu = config.mtu;
        this._name = config.name;
        this._tags = config.tags;
        this._vlan = config.vlan;
        this._vpnGatewayId = config.vpnGatewayId;
        this._timeouts = config.timeouts;
    }
    get addressFamily() {
        return this._addressFamily;
    }
    set addressFamily(value) {
        this._addressFamily = value;
    }
    get amazonAddress() {
        var _a;
        return (_a = this._amazonAddress) !== null && _a !== void 0 ? _a : this.getStringAttribute('amazon_address');
    }
    set amazonAddress(value) {
        this._amazonAddress = value;
    }
    // amazon_side_asn - computed: true, optional: false, required: true
    get amazonSideAsn() {
        return this.getStringAttribute('amazon_side_asn');
    }
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    // aws_device - computed: true, optional: false, required: true
    get awsDevice() {
        return this.getStringAttribute('aws_device');
    }
    get bgpAsn() {
        return this._bgpAsn;
    }
    set bgpAsn(value) {
        this._bgpAsn = value;
    }
    get bgpAuthKey() {
        var _a;
        return (_a = this._bgpAuthKey) !== null && _a !== void 0 ? _a : this.getStringAttribute('bgp_auth_key');
    }
    set bgpAuthKey(value) {
        this._bgpAuthKey = value;
    }
    get connectionId() {
        return this._connectionId;
    }
    set connectionId(value) {
        this._connectionId = value;
    }
    get customerAddress() {
        var _a;
        return (_a = this._customerAddress) !== null && _a !== void 0 ? _a : this.getStringAttribute('customer_address');
    }
    set customerAddress(value) {
        this._customerAddress = value;
    }
    get dxGatewayId() {
        return this._dxGatewayId;
    }
    set dxGatewayId(value) {
        this._dxGatewayId = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    // jumbo_frame_capable - computed: true, optional: false, required: true
    get jumboFrameCapable() {
        return this.getBooleanAttribute('jumbo_frame_capable');
    }
    get mtu() {
        return this._mtu;
    }
    set mtu(value) {
        this._mtu = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get vlan() {
        return this._vlan;
    }
    set vlan(value) {
        this._vlan = value;
    }
    get vpnGatewayId() {
        return this._vpnGatewayId;
    }
    set vpnGatewayId(value) {
        this._vpnGatewayId = value;
    }
    get timeouts() {
        return this._timeouts;
    }
    set timeouts(value) {
        this._timeouts = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            address_family: this._addressFamily,
            amazon_address: this._amazonAddress,
            bgp_asn: this._bgpAsn,
            bgp_auth_key: this._bgpAuthKey,
            connection_id: this._connectionId,
            customer_address: this._customerAddress,
            dx_gateway_id: this._dxGatewayId,
            mtu: this._mtu,
            name: this._name,
            tags: this._tags,
            vlan: this._vlan,
            vpn_gateway_id: this._vpnGatewayId,
            timeouts: this._timeouts,
        };
    }
}
exports.DxPrivateVirtualInterface = DxPrivateVirtualInterface;
//# sourceMappingURL=data:application/json;base64,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