import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DxPublicVirtualInterfaceConfig extends TerraformMetaArguments {
    readonly addressFamily: string;
    readonly amazonAddress?: string;
    readonly bgpAsn: number;
    readonly bgpAuthKey?: string;
    readonly connectionId: string;
    readonly customerAddress?: string;
    readonly name: string;
    readonly routeFilterPrefixes: string[];
    readonly tags?: {
        [key: string]: string;
    };
    readonly vlan: number;
    /** timeouts block */
    readonly timeouts?: DxPublicVirtualInterfaceTimeouts;
}
export interface DxPublicVirtualInterfaceTimeouts {
    readonly create?: string;
    readonly delete?: string;
}
export declare class DxPublicVirtualInterface extends TerraformResource {
    constructor(scope: Construct, id: string, config: DxPublicVirtualInterfaceConfig);
    private _addressFamily;
    get addressFamily(): string;
    set addressFamily(value: string);
    private _amazonAddress?;
    get amazonAddress(): string | undefined;
    set amazonAddress(value: string | undefined);
    get amazonSideAsn(): string;
    get arn(): string;
    get awsDevice(): string;
    private _bgpAsn;
    get bgpAsn(): number;
    set bgpAsn(value: number);
    private _bgpAuthKey?;
    get bgpAuthKey(): string | undefined;
    set bgpAuthKey(value: string | undefined);
    private _connectionId;
    get connectionId(): string;
    set connectionId(value: string);
    private _customerAddress?;
    get customerAddress(): string | undefined;
    set customerAddress(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _routeFilterPrefixes;
    get routeFilterPrefixes(): string[];
    set routeFilterPrefixes(value: string[]);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _vlan;
    get vlan(): number;
    set vlan(value: number);
    private _timeouts?;
    get timeouts(): DxPublicVirtualInterfaceTimeouts | undefined;
    set timeouts(value: DxPublicVirtualInterfaceTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
